/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.registry;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import net.blay09.mods.excompressum.ExCompressum;
import net.blay09.mods.excompressum.api.RegistryType;
import net.blay09.mods.excompressum.api.ReloadRegistryEvent;
import net.blay09.mods.excompressum.config.ExCompressumConfig;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class AbstractRegistry {
    public static List<String> registryErrors = Lists.newArrayList();
    protected final String registryName;
    private boolean hasChanged;
    private boolean refuseSave;

    public AbstractRegistry(String registryName) {
        this.registryName = registryName;
    }

    public final void load(File configDir) {
        Throwable throwable;
        this.clear();
        Gson gson = new Gson();
        File configFile = new File(configDir, this.registryName + ".json");
        if (!configFile.exists()) {
            try (JsonWriter jsonWriter = new JsonWriter((Writer)new FileWriter(configFile));){
                jsonWriter.setIndent("  ");
                gson.toJson((JsonElement)this.create(), jsonWriter);
            }
            catch (IOException e) {
                ExCompressum.logger.error("Failed to create default {} registry: {}", new Object[]{this.registryName, e});
            }
        }
        JsonObject root = null;
        try {
            throwable = null;
            try (JsonReader jsonReader = new JsonReader((Reader)new FileReader(configFile));){
                jsonReader.setLenient(true);
                root = (JsonObject)gson.fromJson(jsonReader, JsonObject.class);
                if (this.hasOptions()) {
                    JsonObject options = this.tryGetObject(root, "options");
                    this.loadOptions(options);
                }
                JsonObject defaults = this.tryGetObject(root, "defaults");
                this.registerDefaults(defaults);
                JsonObject custom = this.tryGetObject(root, "custom");
                JsonArray entries = this.tryGetArray(custom, "entries");
                for (int i = 0; i < entries.size(); ++i) {
                    JsonElement element = entries.get(i);
                    if (element.isJsonObject()) {
                        this.loadCustom(element.getAsJsonObject());
                        continue;
                    }
                    this.logError("Failed to preInit %s registry: entries must be an array of json objects", this.registryName);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (JsonSyntaxException | IOException | ClassCastException e) {
            this.logError("Failed to preInit %s registry: %s", this.registryName, e);
            this.refuseSave = true;
        }
        if (root != null && this.hasChanged && !this.refuseSave) {
            try {
                throwable = null;
                try (JsonWriter jsonWriter = new JsonWriter((Writer)new FileWriter(configFile));){
                    jsonWriter.setIndent("  ");
                    gson.toJson((JsonElement)root, jsonWriter);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (IOException e) {
                ExCompressum.logger.error("Failed to save updated {} registry: {}", new Object[]{this.registryName, e});
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new ReloadRegistryEvent(this.getRegistryType()));
    }

    protected abstract void clear();

    protected abstract JsonObject create();

    protected abstract void loadCustom(JsonObject var1);

    protected abstract void registerDefaults(JsonObject var1);

    protected abstract RegistryType getRegistryType();

    protected void loadOptions(JsonObject entry) {
    }

    protected boolean hasOptions() {
        return false;
    }

    protected final boolean tryGetBoolean(JsonObject root, String key, boolean defaultValue) {
        JsonElement element;
        if (root.has(key) && (element = root.get(key)).isJsonPrimitive()) {
            return element.getAsBoolean();
        }
        root.addProperty(key, Boolean.valueOf(defaultValue));
        this.hasChanged = true;
        return defaultValue;
    }

    protected final int tryGetInt(JsonObject root, String key, int defaultValue) {
        JsonElement element;
        if (root.has(key) && (element = root.get(key)).isJsonPrimitive()) {
            return element.getAsInt();
        }
        root.addProperty(key, (Number)defaultValue);
        this.hasChanged = true;
        return defaultValue;
    }

    protected final float tryGetFloat(JsonObject root, String key, float defaultValue) {
        JsonElement element;
        if (root.has(key) && (element = root.get(key)).isJsonPrimitive()) {
            return element.getAsFloat();
        }
        root.addProperty(key, (Number)Float.valueOf(defaultValue));
        this.hasChanged = true;
        return defaultValue;
    }

    protected final String tryGetString(JsonObject root, String key, String defaultValue) {
        JsonElement element;
        if (root.has(key) && (element = root.get(key)).isJsonPrimitive()) {
            return element.getAsString();
        }
        root.addProperty(key, defaultValue);
        this.hasChanged = true;
        return defaultValue;
    }

    protected final JsonObject tryGetObject(JsonObject root, String key) {
        if (root.has(key)) {
            JsonElement element = root.get(key);
            if (element.isJsonObject()) {
                return element.getAsJsonObject();
            }
            this.logError("Invalid configuration format: expected %s to be a json object in %s, but got %s", key, this.registryName, element.getClass().toString());
            this.refuseSave = true;
            return new JsonObject();
        }
        JsonObject newObject = new JsonObject();
        root.add(key, (JsonElement)newObject);
        this.hasChanged = true;
        return newObject;
    }

    protected final JsonArray tryGetArray(JsonObject root, String key) {
        if (root.has(key)) {
            JsonElement element = root.get(key);
            if (element.isJsonArray()) {
                return element.getAsJsonArray();
            }
            this.logError("Invalid configuration format: expected %s to be a json array in %s, but got %s", key, this.registryName, element.getClass().toString());
            this.refuseSave = true;
            return new JsonArray();
        }
        JsonArray newArray = new JsonArray();
        root.add(key, (JsonElement)newArray);
        this.hasChanged = true;
        return newArray;
    }

    protected final int tryParseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            this.logError("Expected number but got %s, falling back to 0...", s);
            this.refuseSave = true;
            return 0;
        }
    }

    protected final void logError(String format, Object ... args) {
        String s = String.format(format, args);
        ExCompressum.logger.error(s);
        registryErrors.add(s);
    }

    protected final void logWarning(String format, Object ... args) {
        String s = String.format(format, args);
        ExCompressum.logger.error(s);
        if (ExCompressumConfig.showRegistryWarnings) {
            registryErrors.add(s);
        }
    }

    protected final void logUnknownItem(ResourceLocation location) {
        String s = String.format("Unknown item '%s' in %s", location, this.registryName);
        ExCompressum.logger.error(s);
        registryErrors.add(s);
    }

    protected final void logUnknownFluid(String fluidName, ResourceLocation location) {
        String s = String.format("Unknown fluid '%s' when registering %s in %s", fluidName, location, this.registryName);
        ExCompressum.logger.error(s);
        registryErrors.add(s);
    }

    protected final void logUnknownOre(ResourceLocation location) {
        ExCompressum.logger.warn("No ore dictionary entries found for {} in {}", new Object[]{location.func_110623_a(), this.registryName});
    }
}

