/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.config;

import com.google.common.collect.Maps;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;

public class ToolsConfig {
    public static boolean allowChickenStickCreation;
    public static float chickenStickSoundChance;
    public static float chickenStickSpawnChance;
    public static ResourceLocation[] chickenStickSounds;
    public static final Map<String, String> chickenStickNames;
    public static float compressedCrookDurabilityMultiplier;
    public static float compressedCrookSpeedMultiplier;
    public static String chickenStickName;

    public static void load(Configuration config) {
        String CATEGORY = "tools";
        String CHICKEN_STICK = "tools.chicken_stick";
        allowChickenStickCreation = config.getBoolean("Allow Creation", "tools.chicken_stick", true, "If true, hitting a chicken with a stick will turn it into an Angry Chicken, which will drop a Chicken Stick when killed.");
        chickenStickSpawnChance = config.getFloat("Chicken Spawn Chance", "tools.chicken_stick", 0.008f, 0.0f, 1.0f, "The chance for the chicken stick to spawn a chicken. Set to 0 to disable.");
        chickenStickSoundChance = config.getFloat("Sound Chance", "tools.chicken_stick", 0.2f, 0.0f, 1.0f, "The chance for the chicken stick to make sounds when breaking blocks. Set to 0 to disable.");
        String[] chickenStickSoundNames = config.getStringList("Sound List", "tools.chicken_stick", new String[]{"entity.chicken.ambient", "entity.chicken.hurt", "entity.chicken.egg", "entity.chicken.step"}, "The sound names the chicken stick will randomly play.");
        chickenStickSounds = new ResourceLocation[chickenStickSoundNames.length];
        for (int i = 0; i < chickenStickSoundNames.length; ++i) {
            ToolsConfig.chickenStickSounds[i] = new ResourceLocation(chickenStickSoundNames[i]);
        }
        String[] chickenStickNameList = config.getStringList("Custom Names", "tools.chicken_stick", new String[0], "Format: Username=ItemName, Username can be * to affect all users");
        chickenStickNames.put("wyld", "The Cluckington");
        chickenStickNames.put("slowpoke101", "Dark Matter Hammer");
        chickenStickNames.put("jake_evans", "Cock Stick");
        for (String name : chickenStickNameList) {
            String[] s = name.split("=");
            if (s.length < 2) continue;
            chickenStickNames.put(s[0].toLowerCase(Locale.ENGLISH), s[1]);
        }
        String COMPRESSED_CROOK = "tools.compressed_crook";
        compressedCrookDurabilityMultiplier = config.getFloat("Durability Multiplier", "tools.compressed_crook", 2.0f, 0.1f, 10.0f, "The multiplier applied to the Compressed Crook's durability (based on the normal wooden crook)");
        compressedCrookSpeedMultiplier = config.getFloat("Speed Multiplier", "tools.compressed_crook", 4.0f, 0.1f, 10.0f, "The multiplier applied to the Compressed Crook's speed (based on the normal wooden crook)");
    }

    @Nullable
    public static String getChickenStickName() {
        return chickenStickName;
    }

    public static void setChickenStickName(String name) {
        chickenStickName = name;
    }

    static {
        chickenStickNames = Maps.newHashMap();
    }
}

