/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.config;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import net.blay09.mods.excompressum.block.BlockBait;
import net.blay09.mods.excompressum.block.BlockCompressed;
import net.blay09.mods.excompressum.block.ModBlocks;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;

public class BlockConfig {
    private static final Map<String, Entry> entries = Maps.newHashMap();

    private static void addEntry(String name, ItemStack itemStack, boolean defaultValue) {
        entries.put(name, new Entry(name, itemStack, defaultValue));
    }

    public static Collection<Entry> getEntries() {
        return entries.values();
    }

    public static boolean isEnabled(String name) {
        Entry entry = entries.get(name);
        return entry != null && entry.isEnabled();
    }

    public static void postLoad(Configuration config) {
        BlockConfig.addEntry("Heavy Sieve", new ItemStack((Block)ModBlocks.heavySieve, 0, Short.MAX_VALUE), true);
        BlockConfig.addEntry("Wooden Crucible", new ItemStack((Block)ModBlocks.woodenCrucible, 0, Short.MAX_VALUE), true);
        BlockConfig.addEntry("Auto Compressor", new ItemStack((Block)ModBlocks.autoCompressor), true);
        BlockConfig.addEntry("Auto Hammer", new ItemStack((Block)ModBlocks.autoHammer), true);
        BlockConfig.addEntry("Auto Compressed Hammer", new ItemStack((Block)ModBlocks.autoCompressedHammer), true);
        BlockConfig.addEntry("Auto Sieve", new ItemStack((Block)ModBlocks.autoSieve), true);
        BlockConfig.addEntry("Auto Heavy Sieve", new ItemStack((Block)ModBlocks.autoHeavySieve), true);
        BlockConfig.addEntry("Mana Sieve", new ItemStack((Block)ModBlocks.manaSieve), true);
        BlockConfig.addEntry("Compressed Dust", new ItemStack((Block)ModBlocks.compressedBlock, 1, BlockCompressed.Type.DUST.ordinal()), true);
        BlockConfig.addEntry("Compressed Soul Sand", new ItemStack((Block)ModBlocks.compressedBlock, 1, BlockCompressed.Type.SOUL_SAND.ordinal()), true);
        BlockConfig.addEntry("Compressed Flint", new ItemStack((Block)ModBlocks.compressedBlock, 1, BlockCompressed.Type.FLINT.ordinal()), true);
        BlockConfig.addEntry("Compressed Nether Gravel", new ItemStack((Block)ModBlocks.compressedBlock, 1, BlockCompressed.Type.NETHER_GRAVEL.ordinal()), true);
        BlockConfig.addEntry("Compressed Ender Gravel", new ItemStack((Block)ModBlocks.compressedBlock, 1, BlockCompressed.Type.ENDER_GRAVEL.ordinal()), true);
        boolean exUtilsLoaded = Loader.isModLoaded((String)"extrautils2");
        BlockConfig.addEntry("Compressed Cobblestone", new ItemStack((Block)ModBlocks.compressedBlock, 1, BlockCompressed.Type.COBBLESTONE.ordinal()), !exUtilsLoaded);
        BlockConfig.addEntry("Compressed Gravel", new ItemStack((Block)ModBlocks.compressedBlock, 1, BlockCompressed.Type.GRAVEL.ordinal()), !exUtilsLoaded);
        BlockConfig.addEntry("Compressed Sand", new ItemStack((Block)ModBlocks.compressedBlock, 1, BlockCompressed.Type.SAND.ordinal()), !exUtilsLoaded);
        BlockConfig.addEntry("Compressed Dirt", new ItemStack((Block)ModBlocks.compressedBlock, 1, BlockCompressed.Type.DIRT.ordinal()), !exUtilsLoaded);
        BlockConfig.addEntry("Compressed Netherrack", new ItemStack((Block)ModBlocks.compressedBlock, 1, BlockCompressed.Type.NETHERRACK.ordinal()), !exUtilsLoaded);
        BlockConfig.addEntry("Compressed End Stone", new ItemStack((Block)ModBlocks.compressedBlock, 1, BlockCompressed.Type.END_STONE.ordinal()), !exUtilsLoaded);
        BlockConfig.addEntry("Wolf Bait", new ItemStack((Block)ModBlocks.bait, 1, BlockBait.Type.WOLF.ordinal()), true);
        BlockConfig.addEntry("Ocelot Bait", new ItemStack((Block)ModBlocks.bait, 1, BlockBait.Type.OCELOT.ordinal()), true);
        BlockConfig.addEntry("Cow Bait", new ItemStack((Block)ModBlocks.bait, 1, BlockBait.Type.COW.ordinal()), true);
        BlockConfig.addEntry("Pig Bait", new ItemStack((Block)ModBlocks.bait, 1, BlockBait.Type.PIG.ordinal()), true);
        BlockConfig.addEntry("Chicken Bait", new ItemStack((Block)ModBlocks.bait, 1, BlockBait.Type.CHICKEN.ordinal()), true);
        BlockConfig.addEntry("Sheep Bait", new ItemStack((Block)ModBlocks.bait, 1, BlockBait.Type.SHEEP.ordinal()), true);
        BlockConfig.addEntry("Squid Bait", new ItemStack((Block)ModBlocks.bait, 1, BlockBait.Type.SQUID.ordinal()), false);
        BlockConfig.addEntry("Rabbit Bait", new ItemStack((Block)ModBlocks.bait, 1, BlockBait.Type.RABBIT.ordinal()), true);
        for (Entry entry : entries.values()) {
            entry.setEnabled(config.getBoolean(entry.getName(), "blocks", entry.getDefaultValue(), "If set to false, the recipe for the " + entry.getName() + " will be disabled (and it won't show up in JEI)."));
        }
    }

    public static class Entry {
        private final String name;
        private final ItemStack itemStack;
        private boolean defaultValue;
        private boolean enabled;

        public Entry(String name, ItemStack itemStack, boolean defaultValue) {
            this.name = name;
            this.itemStack = itemStack;
            this.defaultValue = defaultValue;
        }

        public String getName() {
            return this.name;
        }

        public ItemStack getItemStack() {
            return this.itemStack;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean getDefaultValue() {
            return this.defaultValue;
        }
    }
}

