/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.compat.jei;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import net.blay09.mods.excompressum.compat.jei.JEIAddon;
import net.blay09.mods.excompressum.registry.RegistryKey;
import net.blay09.mods.excompressum.registry.heavysieve.HeavySieveRegistryEntry;
import net.blay09.mods.excompressum.registry.heavysieve.HeavySieveReward;
import net.blay09.mods.excompressum.registry.sievemesh.SieveMeshRegistry;
import net.blay09.mods.excompressum.registry.sievemesh.SieveMeshRegistryEntry;
import net.blay09.mods.excompressum.utils.StupidUtils;
import net.minecraft.item.ItemStack;

public class HeavySieveRecipe
extends BlankRecipeWrapper {
    private final HeavySieveRegistryEntry entry;
    private final SieveMeshRegistryEntry sieveMesh;
    private final List<Object> inputs;
    private final List<ItemStack> outputs;
    private final ArrayListMultimap<RegistryKey, HeavySieveReward> rewards;

    public HeavySieveRecipe(HeavySieveRegistryEntry entry) {
        this(entry, null);
    }

    public HeavySieveRecipe(HeavySieveRegistryEntry entry, @Nullable SieveMeshRegistryEntry sieveMesh) {
        this.entry = entry;
        this.sieveMesh = sieveMesh;
        this.inputs = Lists.newArrayList();
        this.rewards = ArrayListMultimap.create();
        if (sieveMesh != null) {
            this.inputs.add(sieveMesh.getItemStack());
            for (HeavySieveReward heavySieveReward : entry.getRewardsForMesh(sieveMesh)) {
                this.rewards.put((Object)new RegistryKey(heavySieveReward.getItemStack()), (Object)heavySieveReward);
            }
        } else {
            ArrayList sieveMeshes = Lists.newArrayList();
            for (SieveMeshRegistryEntry meshEntry : SieveMeshRegistry.getEntries().values()) {
                sieveMeshes.add(meshEntry.getItemStack());
            }
            this.inputs.add(sieveMeshes);
            for (HeavySieveReward reward : entry.getRewards()) {
                this.rewards.put((Object)new RegistryKey(reward.getItemStack()), (Object)reward);
            }
        }
        this.outputs = Lists.newArrayList();
        for (RegistryKey registryKey : this.rewards.keySet()) {
            this.outputs.add(((HeavySieveReward)this.rewards.get((Object)registryKey).get(0)).getItemStack());
        }
        ItemStack inputStack = StupidUtils.getItemStackFromState(entry.getInputState());
        this.inputs.add(inputStack);
    }

    public Collection<HeavySieveReward> getRewardsForItemStack(ItemStack itemStack) {
        return this.rewards.get((Object)new RegistryKey(itemStack));
    }

    public HeavySieveRegistryEntry getEntry() {
        return this.entry;
    }

    public void getIngredients(IIngredients ingredients) {
        List inputs = JEIAddon.jeiHelpers.getStackHelper().expandRecipeItemStackInputs(this.inputs);
        ingredients.setInputLists(ItemStack.class, inputs);
        ingredients.setOutputs(ItemStack.class, this.outputs);
    }
}

