/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.client;

import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.Locale;
import java.util.Set;
import net.blay09.mods.excompressum.CommonProxy;
import net.blay09.mods.excompressum.block.ModBlocks;
import net.blay09.mods.excompressum.client.render.entity.RenderAngryChicken;
import net.blay09.mods.excompressum.client.render.tile.RenderAutoHammer;
import net.blay09.mods.excompressum.client.render.tile.RenderAutoSieve;
import net.blay09.mods.excompressum.client.render.tile.RenderBait;
import net.blay09.mods.excompressum.client.render.tile.RenderHeavySieve;
import net.blay09.mods.excompressum.client.render.tile.RenderWoodenCrucible;
import net.blay09.mods.excompressum.compat.IAddon;
import net.blay09.mods.excompressum.config.ToolsConfig;
import net.blay09.mods.excompressum.entity.EntityAngryChicken;
import net.blay09.mods.excompressum.item.ModItems;
import net.blay09.mods.excompressum.tile.TileAutoCompressedHammer;
import net.blay09.mods.excompressum.tile.TileAutoHammer;
import net.blay09.mods.excompressum.tile.TileAutoHeavySieve;
import net.blay09.mods.excompressum.tile.TileAutoSieve;
import net.blay09.mods.excompressum.tile.TileAutoSieveMana;
import net.blay09.mods.excompressum.tile.TileBait;
import net.blay09.mods.excompressum.tile.TileHeavySieve;
import net.blay09.mods.excompressum.tile.TileWoodenCrucible;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelChicken;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ClientProxy
extends CommonProxy {
    private final Set<GameProfile> skinRequested = Sets.newHashSet();
    public static TextureAtlasSprite iconEmptyBookSlot;
    public static TextureAtlasSprite iconEmptyMeshSlot;
    public static TextureAtlasSprite iconEmptyHammerSlot;
    public static TextureAtlasSprite iconEmptyCompressedHammerSlot;
    public static TextureAtlasSprite ironMeshSprite;
    public static TextureAtlasSprite stringMeshSprite;
    public static TextureAtlasSprite flintMeshSprite;
    public static TextureAtlasSprite diamondMeshSprite;
    public static final TextureAtlasSprite[] destroyBlockIcons;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModItems.registerModels();
        ModBlocks.registerModels();
        ClientRegistry.bindTileEntitySpecialRenderer(TileHeavySieve.class, (TileEntitySpecialRenderer)new RenderHeavySieve());
        ClientRegistry.bindTileEntitySpecialRenderer(TileAutoSieve.class, (TileEntitySpecialRenderer)new RenderAutoSieve(false));
        ClientRegistry.bindTileEntitySpecialRenderer(TileAutoSieveMana.class, (TileEntitySpecialRenderer)new RenderAutoSieve(false));
        ClientRegistry.bindTileEntitySpecialRenderer(TileAutoHeavySieve.class, (TileEntitySpecialRenderer)new RenderAutoSieve(true));
        ClientRegistry.bindTileEntitySpecialRenderer(TileAutoHammer.class, (TileEntitySpecialRenderer)new RenderAutoHammer(false));
        ClientRegistry.bindTileEntitySpecialRenderer(TileAutoCompressedHammer.class, (TileEntitySpecialRenderer)new RenderAutoHammer(true));
        ClientRegistry.bindTileEntitySpecialRenderer(TileWoodenCrucible.class, (TileEntitySpecialRenderer)new RenderWoodenCrucible());
        ClientRegistry.bindTileEntitySpecialRenderer(TileBait.class, (TileEntitySpecialRenderer)new RenderBait());
        final ModelChicken modelChicken = new ModelChicken();
        RenderingRegistry.registerEntityRenderingHandler(EntityAngryChicken.class, (IRenderFactory)new IRenderFactory<EntityAngryChicken>(){

            public Render<? super EntityAngryChicken> createRenderFor(RenderManager manager) {
                return new RenderAngryChicken(manager, (ModelBase)modelChicken, 0.3f);
            }
        });
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        String customName = ToolsConfig.chickenStickNames.get(Minecraft.func_71410_x().func_110432_I().func_111285_a().toLowerCase(Locale.ENGLISH));
        if (customName == null) {
            customName = ToolsConfig.chickenStickNames.get("*");
        }
        if (customName != null) {
            ToolsConfig.setChickenStickName(customName);
        }
    }

    @Override
    public void preloadSkin(GameProfile customSkin) {
        if (!this.skinRequested.contains(customSkin)) {
            Minecraft.func_71410_x().func_152342_ad().func_152790_a(customSkin, new SkinManager.SkinAvailableCallback(){

                public void func_180521_a(MinecraftProfileTexture.Type typeIn, ResourceLocation location, MinecraftProfileTexture profileTexture) {
                }
            }, true);
            this.skinRequested.add(customSkin);
        }
    }

    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Pre event) {
        if (event.getMap() == Minecraft.func_71410_x().func_147117_R()) {
            iconEmptyBookSlot = event.getMap().func_174942_a(new ResourceLocation("excompressum", "items/empty_enchanted_book_slot"));
            iconEmptyMeshSlot = event.getMap().func_174942_a(new ResourceLocation("excompressum", "items/empty_mesh_slot"));
            iconEmptyHammerSlot = event.getMap().func_174942_a(new ResourceLocation("excompressum", "items/empty_hammer_slot"));
            iconEmptyCompressedHammerSlot = event.getMap().func_174942_a(new ResourceLocation("excompressum", "items/empty_compressed_hammer_slot"));
            stringMeshSprite = event.getMap().func_174942_a(new ResourceLocation("excompressum", "blocks/string_mesh"));
            flintMeshSprite = event.getMap().func_174942_a(new ResourceLocation("excompressum", "blocks/flint_mesh"));
            ironMeshSprite = event.getMap().func_174942_a(new ResourceLocation("excompressum", "blocks/iron_mesh"));
            diamondMeshSprite = event.getMap().func_174942_a(new ResourceLocation("excompressum", "blocks/diamond_mesh"));
        }
    }

    @SubscribeEvent
    public void afterTextureStitch(TextureStitchEvent.Post event) {
        for (int i = 0; i < destroyBlockIcons.length; ++i) {
            ClientProxy.destroyBlockIcons[i] = event.getMap().func_110572_b("minecraft:blocks/destroy_stage_" + i);
        }
    }

    @Override
    public void preInitAddon(IAddon addon) {
        addon.clientInit();
    }

    @Override
    public void addScheduledTask(Runnable runnable) {
        Minecraft.func_71410_x().func_152344_a(runnable);
    }

    static {
        destroyBlockIcons = new TextureAtlasSprite[10];
    }
}

