/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.server.cmd;

import info.ata4.minecraft.dragon.server.cmd.CommandBaseDragon;
import info.ata4.minecraft.dragon.server.entity.EntityTameableDragon;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.SyntaxErrorException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;

public class CommandDragonEnumSetter<E extends Enum<E>>
extends CommandBaseDragon {
    private final Class<E> enumClass;
    private final BiConsumer<EntityTameableDragon, E> enumConsumer;

    public CommandDragonEnumSetter(String name, Class<E> enumClass, BiConsumer<EntityTameableDragon, E> enumConsumer) {
        super(name);
        this.enumClass = enumClass;
        this.enumConsumer = enumConsumer;
    }

    private List<String> getEnumNames() {
        return EnumUtils.getEnumList(this.enumClass).stream().map(e -> e.name().toLowerCase()).collect(Collectors.toList());
    }

    public String func_71518_a(ICommandSender sender) {
        return String.format("%s <%s>", this.func_71517_b(), StringUtils.join(this.getEnumNames(), (char)'|'));
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        String enumName = args[0].toUpperCase();
        Enum enumValue = EnumUtils.getEnum(this.enumClass, (String)enumName);
        if (enumValue == null) {
            throw new SyntaxErrorException("commands.generic.syntax", new Object[0]);
        }
        this.applyModifier(server, sender, dragon -> this.enumConsumer.accept((EntityTameableDragon)((Object)dragon), (E)enumValue));
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        return CommandBase.func_175762_a((String[])args, this.getEnumNames());
    }
}

