/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.gyth.blocks;

import java.util.List;
import java.util.Random;
import net.darkhax.bookshelf.lib.BlockStates;
import net.darkhax.bookshelf.lib.util.ItemStackUtils;
import net.darkhax.gyth.Gyth;
import net.darkhax.gyth.api.GythApi;
import net.darkhax.gyth.api.TankTier;
import net.darkhax.gyth.items.ItemTankUpgrade;
import net.darkhax.gyth.libs.ConfigurationHandler;
import net.darkhax.gyth.tileentity.TileEntityModularTank;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTank
extends BlockContainer {
    public BlockTank() {
        super(Material.field_151592_s);
        this.func_149663_c("gyth.tank");
        this.setRegistryName(new ResourceLocation("gyth", "modular_tank"));
        this.func_149647_a(Gyth.tabGyth);
        this.func_149711_c(0.3f);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_180632_j((IBlockState)((IExtendedBlockState)this.field_176227_L.func_177621_b()).withProperty((IUnlistedProperty)BlockStates.HELD_STATE, null).withProperty((IUnlistedProperty)BlockStates.BLOCK_ACCESS, null).withProperty((IUnlistedProperty)BlockStates.BLOCKPOS, null));
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntityModularTank tank = (TileEntityModularTank)worldIn.func_175625_s(pos);
        FluidStack fluid = FluidUtil.getFluidContained((ItemStack)heldItem);
        if (tank == null || tank.getTier() == null || ConfigurationHandler.handleTemperature && tank.getTier().isFlammable((IBlockAccess)worldIn, pos, side) && fluid != null && fluid.getFluid().getTemperature(fluid) > ConfigurationHandler.maxFluidHeat || !tank.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side)) {
            return heldItem != null && !(heldItem.func_77973_b() instanceof ItemBlock);
        }
        if (tank != null && heldItem != null && heldItem.func_77973_b() instanceof ItemTankUpgrade) {
            TankTier upgradeTier = GythApi.getTierFromStack(heldItem);
            if (tank != null && !tank.func_145837_r() && upgradeTier != null && tank.getTier() != null && tank.getTier().canApplyUpgrage(upgradeTier)) {
                tank.upgradeTank(upgradeTier, state);
                --heldItem.field_77994_a;
                return true;
            }
        }
        IFluidHandler fluidHandler = (IFluidHandler)tank.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side);
        FluidUtil.interactWithFluidHandler((ItemStack)heldItem, (IFluidHandler)fluidHandler, (EntityPlayer)playerIn);
        return heldItem != null && !(heldItem.func_77973_b() instanceof ItemBlock);
    }

    public BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[0], new IUnlistedProperty[]{BlockStates.HELD_STATE, BlockStates.BLOCK_ACCESS, BlockStates.BLOCKPOS});
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityModularTank tile;
        state = ((IExtendedBlockState)state).withProperty((IUnlistedProperty)BlockStates.BLOCK_ACCESS, (Object)world).withProperty((IUnlistedProperty)BlockStates.BLOCKPOS, (Object)pos);
        if (world.func_175625_s(pos) instanceof TileEntityModularTank && (tile = (TileEntityModularTank)world.func_175625_s(pos)) != null && tile.getTier() != null) {
            return ((IExtendedBlockState)state).withProperty((IUnlistedProperty)BlockStates.HELD_STATE, (Object)tile.getTier().renderState);
        }
        return state;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityModularTank();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return ItemStackUtils.createStackFromTileEntity((TileEntity)world.func_175625_s(pos));
    }

    public int func_149745_a(Random rnd) {
        return 0;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return 0;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (!player.field_71075_bZ.field_75098_d) {
            TileEntityModularTank tank = (TileEntityModularTank)world.func_175625_s(pos);
            ItemStackUtils.dropStackInWorld((World)world, (BlockPos)pos, (ItemStack)ItemStackUtils.createStackFromTileEntity((TileEntity)tank));
        }
        return world.func_175698_g(pos);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntityModularTank tank;
        if (stack.func_77942_o() && (tank = (TileEntityModularTank)worldIn.func_175625_s(pos)) != null) {
            tank.readNBT(stack.func_77978_p().func_74775_l("TileData"));
        }
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        ItemStackUtils.dropStackInWorld((World)world, (BlockPos)pos, (ItemStack)ItemStackUtils.createStackFromTileEntity((TileEntity)world.func_175625_s(pos)));
        world.func_175698_g(pos);
        this.func_180652_a(world, pos, explosion);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> itemList) {
        for (TankTier tier : GythApi.REGISTRY.values()) {
            itemList.add(GythApi.createTieredTank(tier));
        }
    }
}

