/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart.microblock;

import mcmultipart.microblock.IMicroblock;
import mcmultipart.multipart.IMultipartContainer;
import mcmultipart.multipart.MultipartHelper;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class MicroblockPlacement {
    public abstract boolean place(World var1, BlockPos var2, boolean var3);

    public abstract IMicroblock getPlacedPart(World var1, BlockPos var2);

    public static class MicroblockPlacementExpand
    extends MicroblockPlacement {
        private final IMicroblock microblock;
        private final IMicroblock expanded;
        private final int amount;

        public MicroblockPlacementExpand(IMicroblock microblockToExpand, IMicroblock expanded, int amount) {
            this.microblock = microblockToExpand;
            this.expanded = expanded;
            this.amount = amount;
        }

        @Override
        public boolean place(World world, BlockPos pos, boolean doPlace) {
            IMultipartContainer container = MultipartHelper.getPartContainer((IBlockAccess)world, pos);
            if (container == null) {
                return false;
            }
            int oldSize = this.microblock.getSize();
            if (container.canReplacePart(this.microblock, this.expanded)) {
                if (doPlace) {
                    this.microblock.setSize(oldSize + this.amount);
                    this.microblock.onPartChanged(this.microblock);
                    this.microblock.sendUpdatePacket();
                }
                return true;
            }
            return false;
        }

        @Override
        public IMicroblock getPlacedPart(World world, BlockPos pos) {
            return this.expanded;
        }
    }

    public static class MicroblockPlacementDefault
    extends MicroblockPlacement {
        private final IMicroblock microblock;

        public MicroblockPlacementDefault(IMicroblock microblock) {
            this.microblock = microblock;
        }

        @Override
        public boolean place(World world, BlockPos pos, boolean doPlace) {
            if (doPlace) {
                return MultipartHelper.addPartIfPossible(world, pos, this.microblock);
            }
            return MultipartHelper.canAddPart(world, pos, this.microblock);
        }

        @Override
        public IMicroblock getPlacedPart(World world, BlockPos pos) {
            return this.microblock;
        }
    }
}

