/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.mods.ic2;

import ic2.api.recipe.IMachineRecipeManager;
import ic2.api.recipe.IRecipeInput;
import java.util.Arrays;
import minetweaker.MineTweakerAPI;
import minetweaker.OneWayAction;
import minetweaker.mods.ic2.IC2RecipeInput;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class MachineAddRecipeAction
extends OneWayAction {
    private final String name;
    private final IMachineRecipeManager machine;
    private final ItemStack[] output;
    private final IC2RecipeInput input;
    private final NBTTagCompound tag;

    public MachineAddRecipeAction(String name, IMachineRecipeManager machine, ItemStack[] output, NBTTagCompound tag, IC2RecipeInput input) {
        this.name = name;
        this.machine = machine;
        this.output = output;
        this.input = input;
        this.tag = tag;
    }

    @Override
    public void apply() {
        try {
            this.machine.addRecipe((IRecipeInput)this.input, this.tag, false, this.output);
        }
        catch (RuntimeException ex) {
            MineTweakerAPI.logError(ex.getMessage());
        }
    }

    @Override
    public String describe() {
        if (this.output.length == 1) {
            return "Adding " + this.name + " recipe for " + this.output[0].func_82833_r();
        }
        StringBuilder result = new StringBuilder();
        result.append("Adding ").append(this.name).append(" recipe for ");
        result.append("[");
        for (int i = 0; i < this.output.length; ++i) {
            if (i == 0) {
                result.append(", ");
                continue;
            }
            result.append(this.output[i].func_82833_r());
        }
        result.append("]");
        return result.toString();
    }

    @Override
    public Object getOverrideKey() {
        return null;
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 47 * hash + (this.machine != null ? this.machine.hashCode() : 0);
        hash = 47 * hash + Arrays.deepHashCode(this.output);
        hash = 47 * hash + (this.input != null ? this.input.hashCode() : 0);
        hash = 47 * hash + (this.tag != null ? this.tag.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MachineAddRecipeAction other = (MachineAddRecipeAction)obj;
        return this.name == null ? other.name == null : this.name.equals(other.name) && (this.machine == other.machine || this.machine != null && this.machine.equals(other.machine)) && Arrays.deepEquals(this.output, other.output) && (this.input == other.input || this.input != null && this.input.equals(other.input)) && (this.tag == other.tag || this.tag != null && this.tag.equals((Object)other.tag));
    }
}

