/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.modcompat.mcmultipart;

import com.google.common.collect.Lists;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import mcmultipart.client.multipart.AdvancedParticleManager;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.IMultipartContainer;
import mcmultipart.multipart.ISlottedPart;
import mcmultipart.multipart.PartSlot;
import mcmultipart.raytrace.PartMOP;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.block.BlockCable;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.helper.WrenchHelpers;
import org.cyclops.integrateddynamics.item.ItemBlockCable;
import org.cyclops.integrateddynamics.modcompat.mcmultipart.MultipartBase;
import org.cyclops.integrateddynamics.modcompat.mcmultipart.PartCable;

public class PartPartType
extends MultipartBase {
    private EnumFacing facing;
    private IPartType partType;

    public PartPartType() {
    }

    public PartPartType(EnumFacing facing, IPartType partType) {
        this();
        this.init(facing, partType);
    }

    public void init(EnumFacing facing, IPartType partType) {
        this.facing = facing;
        this.partType = partType;
    }

    public static ResourceLocation getType(IPartType partType) {
        return partType.getBlockModelPath();
    }

    public ResourceLocation getType() {
        return PartPartType.getType(this.getPartType());
    }

    @Override
    protected ItemStack getItemStack() {
        return new ItemStack(this.getPartType().getItem());
    }

    @Override
    public List<ItemStack> getDrops() {
        LinkedList drops = Lists.newLinkedList();
        IPartState partState = this.getDelegatedPartState();
        if (partState != null) {
            this.getPartType().addDrops(this.getPartTarget(), partState, drops, true);
        } else {
            drops.add(this.getItemStack());
        }
        return drops;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        Pair<EnumFacing, IPartType> part;
        super.readFromNBT(tag);
        if (!tag.func_150296_c().isEmpty() && (part = PartHelpers.readPartTypeFromNBT(this.getNetwork(), this.getPos(), tag.func_74775_l("part"))) != null) {
            this.facing = (EnumFacing)part.getKey();
            this.partType = (IPartType)part.getValue();
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag = super.writeToNBT(tag);
        NBTTagCompound partTag = new NBTTagCompound();
        PartHelpers.writePartTypeToNBT(partTag, this.getFacing(), this.getPartType());
        tag.func_74782_a("part", (NBTBase)partTag);
        return tag;
    }

    public IBlockState getActualState(IBlockState state) {
        return this.getPartType().getBlockState(this.getPartContainer(), this.getFacing());
    }

    public BlockStateContainer createBlockState() {
        return this.getPartType().getBaseBlockState();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.getPartType().getPartRenderPosition().getBoundingBox(this.getFacing());
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(AdvancedParticleManager advancedParticleManager) {
        advancedParticleManager.addBlockDestroyEffects(this.getPos(), BlockCable.getInstance().texture);
        return true;
    }

    public void addOcclusionBoxes(List<AxisAlignedBB> list) {
        list.add(this.getRenderBoundingBox());
    }

    public void addSelectionBoxes(List<AxisAlignedBB> list) {
        list.add(this.getRenderBoundingBox());
    }

    public void addCollisionBoxes(AxisAlignedBB mask, List<AxisAlignedBB> list, Entity collidingEntity) {
        AxisAlignedBB boundingBox = this.getRenderBoundingBox();
        if (mask.func_72326_a(boundingBox)) {
            list.add(boundingBox);
        }
    }

    public boolean canRenderInLayer(BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT;
    }

    public ResourceLocation getModelPath() {
        return this.getPartType().getBlockModelPath();
    }

    public EnumSet<PartSlot> getSlotMask() {
        return EnumSet.of(PartSlot.getFaceSlot((EnumFacing)this.getFacing()));
    }

    public void onRemoved() {
        super.onRemoved();
        if (this.getPartCable() != null && this.getPartCable().hasPart(this.getFacing())) {
            PartHelpers.removePart(this.getWorld(), this.getPos(), this.getFacing(), null, false, false);
        }
    }

    public boolean onActivated(EntityPlayer player, EnumHand hand, ItemStack heldItem, PartMOP hit) {
        World world = player.field_70170_p;
        BlockPos pos = hit.func_178782_a();
        if (!world.field_72995_K && WrenchHelpers.isWrench(player, heldItem, world, pos, hit.field_178784_b)) {
            if (player.func_70093_af()) {
                PartCable cable = this.getPartCable();
                if (cable == null) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        ItemStackHelpers.spawnItemStackToPlayer((World)world, (BlockPos)pos, (ItemStack)this.getItemStack(), (EntityPlayer)player);
                    }
                    this.getContainer().removePart((IMultipart)this);
                } else {
                    PartHelpers.removePart(world, pos, this.getFacing(), player, false, true);
                }
                ItemBlockCable.playBreakSound(world, pos, BlockCable.getInstance().func_176223_P());
            }
            return true;
        }
        IPartState partState = this.getDelegatedPartState();
        if (partState != null) {
            return this.getPartType().onPartActivated(this.getWorld(), this.getPos(), partState, player, hand, heldItem, this.getFacing(), (float)hit.field_72307_f.field_72450_a, (float)hit.field_72307_f.field_72448_b, (float)hit.field_72307_f.field_72449_c) || super.onActivated(player, hand, heldItem, hit);
        }
        return false;
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    protected PartTarget getPartTarget() {
        return PartTarget.fromCenter(DimPos.of((World)this.getWorld(), (BlockPos)this.getPos()), this.getFacing());
    }

    protected PartCable getPartCable() {
        ISlottedPart centerPart;
        IMultipartContainer multipartContainer = this.getContainer();
        if (multipartContainer != null && (centerPart = multipartContainer.getPartInSlot(PartSlot.CENTER)) instanceof PartCable) {
            return (PartCable)centerPart;
        }
        return null;
    }

    public IPartContainer getPartContainer() {
        return PartHelpers.getPartContainer((IBlockAccess)this.getWorld(), this.getPos());
    }

    public IPartType getPartType() {
        return this.partType;
    }

    public IPartState getDelegatedPartState() {
        IPartContainer partContainer = this.getPartContainer();
        if (partContainer != null) {
            return partContainer.getPartState(this.getFacing());
        }
        return null;
    }

    public INetwork getNetwork() {
        PartCable partCable = this.getPartCable();
        if (partCable != null) {
            return partCable.getNetwork();
        }
        return null;
    }
}

