/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.item;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.config.configurable.ConfigurableItem;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.block.cable.ICableFakeable;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.block.BlockCable;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.item.ItemBlockCable;

public class ItemPart<P extends IPartType<P, S>, S extends IPartState<P>>
extends ConfigurableItem {
    private static final List<IUseAction> USE_ACTIONS = Lists.newArrayList();
    private final IPartType<P, S> part;

    public ItemPart(ExtendedConfig eConfig, IPartType<P, S> part) {
        super(eConfig);
        this.part = part;
    }

    public static void addUseAction(IUseAction useAction) {
        USE_ACTIONS.add(useAction);
    }

    public String func_77653_i(ItemStack stack) {
        return L10NHelpers.localize((String)this.part.getUnlocalizedName());
    }

    public EnumActionResult func_180614_a(ItemStack itemStack, EntityPlayer playerIn, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        IPartContainer partContainerFirst = PartHelpers.getPartContainer((IBlockAccess)world, pos);
        if (partContainerFirst != null) {
            if (PartHelpers.addPart(world, pos, side, this.getPart(), itemStack)) {
                if (world.field_72995_K) {
                    ItemBlockCable.playPlaceSound(world, pos);
                }
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    --itemStack.field_77994_a;
                }
            }
            return EnumActionResult.SUCCESS;
        }
        BlockPos target = pos.func_177972_a(side);
        if (world.func_180495_p(target).func_177230_c().func_176200_f((IBlockAccess)world, target)) {
            IPartContainer partContainer;
            ItemBlockCable itemBlockCable = (ItemBlockCable)Item.func_150898_a((Block)BlockCable.getInstance());
            if (itemBlockCable.func_180614_a(itemStack, playerIn, world, target, hand, side, hitX, hitY, hitZ) == EnumActionResult.SUCCESS && (partContainer = PartHelpers.getPartContainer((IBlockAccess)world, target)) != null) {
                if (!world.field_72995_K) {
                    PartHelpers.addPart(world, target, side.func_176734_d(), this.getPart(), itemStack);
                    ICableFakeable cableFakeable = CableHelpers.getCableFakeable((IBlockAccess)world, target);
                    if (cableFakeable != null) {
                        CableHelpers.onCableRemoving(world, target, false);
                        cableFakeable.setRealCable(false);
                        CableHelpers.onCableRemoved(world, target);
                    } else {
                        IntegratedDynamics.clog(Level.WARN, String.format("Tried to set a fake cable at a block that is not fakeable at %s", target));
                    }
                }
                return EnumActionResult.SUCCESS;
            }
        } else {
            IPartContainer partContainer = PartHelpers.getPartContainer((IBlockAccess)world, target);
            if (partContainer != null) {
                if (PartHelpers.addPart(world, target, side.func_176734_d(), this.getPart(), itemStack)) {
                    if (world.field_72995_K) {
                        ItemBlockCable.playPlaceSound(world, target);
                    }
                    if (!playerIn.field_71075_bZ.field_75098_d) {
                        --itemStack.field_77994_a;
                    }
                }
                return EnumActionResult.SUCCESS;
            }
        }
        for (IUseAction useAction : USE_ACTIONS) {
            if (!useAction.attempItemUseTarget(this, itemStack, world, pos, side)) continue;
            return EnumActionResult.SUCCESS;
        }
        return super.func_180614_a(itemStack, playerIn, world, pos, hand, side, hitX, hitY, hitZ);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List list, boolean par4) {
        if (itemStack.func_77978_p() != null) {
            int id = itemStack.func_77978_p().func_74762_e("id");
            list.add(L10NHelpers.localize((String)"item.items.integrateddynamics.general.id", (Object[])new Object[]{id}));
        }
        L10NHelpers.addOptionalInfo((List)list, (String)this.getPart().getUnlocalizedNameBase());
        super.func_77624_a(itemStack, entityPlayer, list, par4);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ItemPart)) {
            return false;
        }
        ItemPart other = (ItemPart)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        IPartType<P, S> this$part = this.getPart();
        IPartType<P, S> other$part = other.getPart();
        return !(this$part == null ? other$part != null : !this$part.equals(other$part));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ItemPart;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IPartType<P, S> $part = this.getPart();
        result = result * 59 + ($part == null ? 43 : $part.hashCode());
        return result;
    }

    public IPartType<P, S> getPart() {
        return this.part;
    }

    public String toString() {
        return "ItemPart(part=" + this.getPart() + ")";
    }

    public static interface IUseAction {
        public boolean attempItemUseTarget(ItemPart var1, ItemStack var2, World var3, BlockPos var4, EnumFacing var5);
    }
}

