/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.render.tileentity;

import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.VertexBufferConsumer;
import org.cyclops.integrateddynamics.api.client.render.part.IPartOverlayRenderer;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.block.BlockCable;
import org.cyclops.integrateddynamics.client.render.part.PartOverlayRenderers;
import org.cyclops.integrateddynamics.core.block.ICollidable;
import org.cyclops.integrateddynamics.core.tileentity.TileMultipartTicking;

public class RenderCable
extends TileEntitySpecialRenderer<TileMultipartTicking> {
    public void renderTileEntityAt(TileMultipartTicking tile, double x, double y, double z, float partialTick, int destroyStage) {
        if (MinecraftForgeClient.getRenderPass() == 0) {
            for (Map.Entry<EnumFacing, IPartType<?, ?>> entry : tile.getPartContainer().getParts().entrySet()) {
                for (IPartOverlayRenderer renderer : PartOverlayRenderers.REGISTRY.getRenderers(entry.getValue())) {
                    renderer.renderPartOverlay(tile.getPartContainer(), x, y, z, partialTick, destroyStage, entry.getKey(), entry.getValue(), this.field_147501_a);
                }
            }
        }
        if (destroyStage >= 0 && MinecraftForgeClient.getRenderPass() == 1) {
            this.startBreaking(this.field_147501_a);
            ICollidable.RayTraceResult result = BlockCable.getInstance().doRayTrace(tile.func_145831_w(), tile.func_174877_v(), (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            IBakedModel model = null;
            if (result != null && result.getCollisionType() != null) {
                model = result.getCollisionType().getBreakingBaseModel(tile.func_145831_w(), tile.func_174877_v(), result.getPositionHit());
            }
            if (model != null) {
                BlockRenderLayer layer = BlockRenderLayer.TRANSLUCENT;
                ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
                IBlockState blockState = this.func_178459_a().func_180495_p(tile.func_174877_v());
                IBakedModel layerModel = new SimpleBakedModel.Builder(blockState, model, Minecraft.func_71410_x().func_147117_R().func_110572_b("minecraft:blocks/destroy_stage_" + destroyStage), tile.func_174877_v()).func_177645_b();
                this.field_147501_a.field_147553_e.func_110577_a(TextureMap.field_110575_b);
                this.startTessellating(x, y, z);
                VertexBufferConsumer consumer = new VertexBufferConsumer(Tessellator.func_178181_a().func_178180_c());
                RenderCable.renderBreaking(blockState, layerModel, (IVertexConsumer)consumer);
                this.finishTessellating();
                ForgeHooksClient.setRenderLayer((BlockRenderLayer)BlockRenderLayer.SOLID);
            }
            this.finishBreaking();
        }
    }

    private void startBreaking(TileEntityRendererDispatcher rendererDispatcher) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179120_a((int)774, (int)768, (int)1, (int)0);
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        GlStateManager.func_179136_a((float)-3.0f, (float)-3.0f);
        GlStateManager.func_179088_q();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179141_d();
        Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
    }

    private void finishBreaking() {
        Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
        GlStateManager.func_179118_c();
        GlStateManager.func_179136_a((float)0.0f, (float)0.0f);
        GlStateManager.func_179113_r();
        GlStateManager.func_179141_d();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179121_F();
    }

    private void startTessellating(double x, double y, double z) {
        Tessellator.func_178181_a().func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181703_c);
        Tessellator.func_178181_a().func_178180_c().func_178969_c(x, y, z);
        Tessellator.func_178181_a().func_178180_c().func_78914_f();
    }

    private void finishTessellating() {
        Tessellator.func_178181_a().func_178180_c().func_178969_c(0.0, 0.0, 0.0);
        Tessellator.func_178181_a().func_78381_a();
    }

    private static void renderBreaking(IBlockState blockState, IBakedModel model, IVertexConsumer consumer) {
        for (EnumFacing face : EnumFacing.field_82609_l) {
            for (BakedQuad quad : model.func_188616_a(blockState, face, 0L)) {
                quad.pipe(consumer);
            }
        }
    }
}

