/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.misc;

import codechicken.lib.vec.Quat;
import codechicken.lib.vec.Vector3;

public class EnderDyeButton {
    public int button;
    public Vector3[] verts;

    public EnderDyeButton(int index) {
        this.button = index;
        this.verts = new Vector3[8];
        this.verts[0] = new Vector3(0.0, -0.25, -0.0625);
        this.verts[1] = new Vector3(0.125, -0.25, -0.0625);
        this.verts[2] = new Vector3(0.125, -0.25, 0.0);
        this.verts[3] = new Vector3(0.0, -0.25, 0.0);
        this.verts[4] = new Vector3(0.0, 0.0, -0.0625);
        this.verts[5] = new Vector3(0.125, 0.0, -0.0625);
        this.verts[6] = new Vector3(0.125, 0.0, 0.0);
        this.verts[7] = new Vector3(0.0, 0.0, 0.0);
        for (int i = 0; i < 8; ++i) {
            this.verts[i].add(0.25 + 0.1875 * (double)index, -0.375, 0.9375);
        }
        Quat quat2 = Quat.aroundAxis((double)1.0, (double)0.0, (double)0.0, (double)-1.570795);
        for (int i = 0; i < 8; ++i) {
            quat2.rotate(this.verts[i]);
        }
    }

    private EnderDyeButton() {
    }

    public void rotateMeta(int angle) {
        this.rotate(0.5, 0.0, 0.5, 0.0, 1.0, 0.0, (double)angle * -0.5 * 3.14159);
    }

    public void rotate(double px, double py, double pz, double ax, double ay, double az, double angle) {
        Quat quat = Quat.aroundAxis((double)ax, (double)ay, (double)az, (double)angle);
        for (int i = 0; i < 8; ++i) {
            this.verts[i].add(-px, -py, -pz);
            quat.rotate(this.verts[i]);
            this.verts[i].add(px, py, pz);
        }
    }

    public EnderDyeButton copy() {
        EnderDyeButton newButton = new EnderDyeButton();
        newButton.button = this.button;
        newButton.verts = new Vector3[8];
        for (int i = 0; i < 8; ++i) {
            newButton.verts[i] = this.verts[i].copy();
        }
        return newButton;
    }

    public void flipCoords(int ax, int ay, int az) {
        for (int i = 0; i < 8; ++i) {
            this.verts[i].add((double)ax, (double)ay, (double)az);
        }
    }

    public Vector3 getMin() {
        int minindex = 0;
        double mindist = 100.0;
        for (int i = 0; i < 8; ++i) {
            double dist = this.verts[i].x + this.verts[i].y + this.verts[i].z;
            if (!(dist < mindist)) continue;
            mindist = dist;
            minindex = i;
        }
        return this.verts[minindex];
    }

    public Vector3 getMax() {
        int maxindex = 0;
        double maxdist = 0.0;
        for (int i = 0; i < 8; ++i) {
            double dist = this.verts[i].x + this.verts[i].y + this.verts[i].z;
            if (!(dist > maxdist)) continue;
            maxdist = dist;
            maxindex = i;
        }
        return this.verts[maxindex];
    }
}

