/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.ingameinfo.printer.xml;

import com.github.lunatrius.ingameinfo.Alignment;
import com.github.lunatrius.ingameinfo.printer.IPrinter;
import com.github.lunatrius.ingameinfo.reference.Reference;
import com.github.lunatrius.ingameinfo.value.Value;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlPrinter
implements IPrinter {
    @Override
    public boolean print(File file, Map<Alignment, List<List<Value>>> format) {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.newDocument();
            Element config = doc.createElement("config");
            this.appendLines(doc, config, format);
            doc.appendChild(config);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            DOMSource source = new DOMSource(doc);
            StreamResult streamResult = new StreamResult(file);
            transformer.transform(source, streamResult);
            return true;
        }
        catch (Exception e) {
            Reference.logger.fatal("Could not save xml configuration file!", (Throwable)e);
            return false;
        }
    }

    private void appendLines(Document doc, Element config, Map<Alignment, List<List<Value>>> format) {
        for (Alignment alignment : Alignment.values()) {
            List<List<Value>> lists = format.get((Object)alignment);
            if (lists == null) continue;
            Element elementLines = doc.createElement("lines");
            elementLines.setAttribute("at", alignment.toString().toLowerCase(Locale.ENGLISH));
            this.appendLine(doc, elementLines, lists);
            if (!elementLines.hasChildNodes()) continue;
            config.appendChild(elementLines);
        }
    }

    private void appendLine(Document doc, Element elementLines, List<List<Value>> lines) {
        for (List<Value> line : lines) {
            Element elementLine = doc.createElement("line");
            this.appendValues(doc, elementLine, line);
            if (!elementLine.hasChildNodes()) continue;
            elementLines.appendChild(elementLine);
        }
    }

    private void appendValues(Document doc, Element elementValues, List<Value> values) {
        for (Value value : values) {
            Element elementValue = doc.createElement(value.getType());
            elementValue.setTextContent(value.getRawValue(false));
            if (value.values.size() > 0) {
                this.appendValues(doc, elementValue, value.values);
            }
            elementValues.appendChild(elementValue);
        }
    }
}

