/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.ingameinfo.handler;

import com.github.lunatrius.ingameinfo.Alignment;
import com.github.lunatrius.ingameinfo.reference.Names;
import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigurationHandler {
    public static final ConfigurationHandler INSTANCE = new ConfigurationHandler();
    public static Configuration configuration;
    public static final String CONFIG_NAME_DEFAULT = "InGameInfo.xml";
    public static final boolean REPLACE_DEBUG_DEFAULT = false;
    public static final boolean SHOW_IN_CHAT_DEFAULT = true;
    public static final boolean SHOW_ON_PLAYER_LIST_DEFAULT = true;
    public static final double SCALE_DEFAULT = 1.0;
    public static final int FILE_INTERVAL_DEFAULT = 5;
    public static final boolean SHOW_OVERLAY_POTIONS_DEFAULT = true;
    public static final boolean SHOW_OVERLAY_ITEM_ICONS_DEFAULT = true;
    public static String configName;
    public static boolean replaceDebug;
    public static boolean showInChat;
    public static boolean showOnPlayerList;
    public static float scale;
    public static int fileInterval;
    public static boolean showOverlayPotions;
    public static boolean showOverlayItemIcons;
    public static Property propConfigName;
    public static Property propReplaceDebug;
    public static Property propShowInChat;
    public static Property propShowOnPlayerList;
    public static Property propScale;
    public static Property propFileInterval;
    public static Property propShowOverlayPotions;
    public static Property propShowOverlayItemIcons;
    public static final Map<Alignment, Property> propAlignments;

    private ConfigurationHandler() {
    }

    public static void init(File configFile) {
        if (configuration == null) {
            configuration = new Configuration(configFile);
            ConfigurationHandler.loadConfiguration();
        }
    }

    private static void loadConfiguration() {
        propConfigName = configuration.get("general", "filename", CONFIG_NAME_DEFAULT, "The configuration that should be loaded on startup.");
        propConfigName.setLanguageKey(Names.Config.LANG_PREFIX + "." + "filename");
        propConfigName.setRequiresMcRestart(true);
        configName = propConfigName.getString();
        propReplaceDebug = configuration.get("general", "replaceDebug", false, "Replace the debug overlay (F3) with the InGameInfoXML overlay.");
        propReplaceDebug.setLanguageKey(Names.Config.LANG_PREFIX + "." + "replaceDebug");
        replaceDebug = propReplaceDebug.getBoolean(false);
        propShowInChat = configuration.get("general", "showInChat", true, "Display the overlay in chat.");
        propShowInChat.setLanguageKey(Names.Config.LANG_PREFIX + "." + "showInChat");
        showInChat = propShowInChat.getBoolean(true);
        propShowOnPlayerList = configuration.get("general", "showOnPlayerList", true, "Display the overlay on the player list.");
        propShowOnPlayerList.setLanguageKey(Names.Config.LANG_PREFIX + "." + "showOnPlayerList");
        showOnPlayerList = propShowOnPlayerList.getBoolean(true);
        propScale = configuration.get("general", "scale", String.valueOf(1.0), "The overlay will be scaled by this amount.");
        propScale.setLanguageKey(Names.Config.LANG_PREFIX + "." + "scale");
        propScale.setValidValues(new String[]{"0.5", "1.0", "1.5", "2.0"});
        scale = (float)propScale.getDouble(1.0);
        propFileInterval = configuration.get("general", "fileInterval", 5, "The interval between file reads for the 'file' tag (in seconds).", 1, 60);
        propFileInterval.setLanguageKey(Names.Config.LANG_PREFIX + "." + "fileInterval");
        fileInterval = propFileInterval.getInt(5);
        propShowOverlayPotions = configuration.get("general", "showOverlayPotions", true, "Display the vanilla potion overlay.");
        propShowOverlayPotions.setLanguageKey(Names.Config.LANG_PREFIX + "." + "showOverlayPotions");
        showOverlayPotions = propShowOverlayPotions.getBoolean(true);
        propShowOverlayItemIcons = configuration.get("general", "showOverlayItemIcons", true, "Display the item overlay on icon (durability, stack size).");
        propShowOverlayItemIcons.setLanguageKey(Names.Config.LANG_PREFIX + "." + "showOverlayItemIcons");
        showOverlayItemIcons = propShowOverlayItemIcons.getBoolean(true);
        for (Alignment alignment : Alignment.values()) {
            String alignmentName = alignment.toString().toLowerCase(Locale.ENGLISH);
            Property property = configuration.get("alignment", alignmentName, alignment.getDefaultXY(), String.format("Offsets for %s (X<space>Y).", alignment.toString()));
            property.setLanguageKey(Names.Config.LANG_PREFIX + "." + alignmentName);
            property.setValidationPattern(Pattern.compile("-?\\d+ -?\\d+"));
            propAlignments.put(alignment, property);
            alignment.setXY(property.getString());
        }
        ConfigurationHandler.save();
    }

    public static void reload() {
        ConfigurationHandler.loadConfiguration();
        ConfigurationHandler.save();
    }

    public static void save() {
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    public static void setConfigName(String name) {
        propConfigName.set(name);
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("InGameInfoXML")) {
            ConfigurationHandler.loadConfiguration();
        }
    }

    static {
        configName = CONFIG_NAME_DEFAULT;
        replaceDebug = false;
        showInChat = true;
        showOnPlayerList = true;
        scale = 1.0f;
        fileInterval = 5;
        showOverlayPotions = true;
        showOverlayItemIcons = true;
        propConfigName = null;
        propReplaceDebug = null;
        propShowInChat = null;
        propShowOnPlayerList = null;
        propScale = null;
        propFileInterval = null;
        propShowOverlayPotions = null;
        propShowOverlayItemIcons = null;
        propAlignments = new HashMap<Alignment, Property>();
    }
}

