/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.network.wrappers;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.blocks.TileBCBase;
import com.brandon3055.brandonscore.network.PacketSyncableObject;
import com.brandon3055.brandonscore.network.wrappers.SyncableObject;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SyncableShort
extends SyncableObject {
    public short value;
    private short lastTickValue;

    public SyncableShort(short value, boolean syncInTile, boolean syncInContainer, boolean updateOnReceived) {
        super(syncInTile, syncInContainer, updateOnReceived);
        this.value = this.lastTickValue = value;
    }

    public SyncableShort(short value, boolean syncInTile, boolean syncInContainer) {
        super(syncInTile, syncInContainer);
        this.value = this.lastTickValue = value;
    }

    @Override
    public void detectAndSendChanges(TileBCBase tile, EntityPlayer player, boolean forceSync) {
        if (this.lastTickValue != this.value || forceSync) {
            this.lastTickValue = this.value;
            tile.dirtyBlock();
            if (player == null) {
                BrandonsCore.network.sendToAllAround((IMessage)new PacketSyncableObject(tile, this.index, this.value, this.updateOnReceived), tile.syncRange());
            } else if (player instanceof EntityPlayerMP) {
                BrandonsCore.network.sendTo((IMessage)new PacketSyncableObject(tile, this.index, this.value, this.updateOnReceived), (EntityPlayerMP)player);
            } else {
                LogHelperBC.error("SyncableInt#detectAndSendChanges No valid destination for sync packet!");
            }
        }
    }

    @Override
    public void updateReceived(PacketSyncableObject packet) {
        if (packet.dataType == 9) {
            this.value = packet.shortValue;
        }
    }

    @Override
    public void toNBT(NBTTagCompound compound) {
        compound.func_74777_a("SyncableShort" + this.index, this.value);
    }

    @Override
    public void fromNBT(NBTTagCompound compound) {
        if (compound.func_74764_b("SyncableShort" + this.index)) {
            this.value = compound.func_74765_d("SyncableShort" + this.index);
        }
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

