/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.config;

import com.brandon3055.brandonscore.config.ModConfigProperty;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ModConfigProcessor {
    private Configuration config;
    private Map<String, String> categoryComments;
    private Class[] configClasses;

    public void initialize(Configuration config, Class ... configClass) {
        this.initialize(config, new HashMap<String, String>(), configClass);
    }

    public void initialize(Configuration config, Map<String, String> categoryComments, Class ... configClasses) {
        this.config = config;
        this.categoryComments = categoryComments;
        this.configClasses = configClasses;
    }

    public void loadConfig() {
        if (this.config == null || this.configClasses == null) {
            throw new RuntimeException("A mod using ModConfigProcessor attempted to load configuration before initializing the config processor or after initializing with null arguments");
        }
        for (Class clazz : this.configClasses) {
            for (Field field : clazz.getFields()) {
                if (!field.isAnnotationPresent(ModConfigProperty.class)) continue;
                ModConfigProperty property = field.getAnnotation(ModConfigProperty.class);
                try {
                    Object defaultValue = field.get(null);
                    Object newValue = ModConfigProcessor.getConfigValue(defaultValue, this.config, property);
                    field.set(null, newValue);
                }
                catch (Exception e) {
                    LogHelperBC.error("Something when wrong while loading config value [" + property.name() + "]");
                    e.printStackTrace();
                }
            }
        }
        for (String category : this.categoryComments.keySet()) {
            this.config.setCategoryComment(category, this.categoryComments.get(category));
        }
        this.saveConfig();
    }

    public static Object getConfigValue(Object defaultValue, Configuration configuration, ModConfigProperty property) throws Exception {
        if (defaultValue instanceof Boolean) {
            return configuration.get(property.category(), property.name(), ((Boolean)defaultValue).booleanValue(), property.comment()).getBoolean(((Boolean)defaultValue).booleanValue());
        }
        if (defaultValue instanceof boolean[]) {
            return configuration.get(property.category(), property.name(), (boolean[])defaultValue, property.comment()).getBooleanList();
        }
        if (defaultValue instanceof Double) {
            return configuration.get(property.category(), property.name(), ((Double)defaultValue).doubleValue(), property.comment()).getDouble(((Double)defaultValue).doubleValue());
        }
        if (defaultValue instanceof double[]) {
            return configuration.get(property.category(), property.name(), (double[])defaultValue, property.comment()).getDoubleList();
        }
        if (defaultValue instanceof Integer) {
            return configuration.get(property.category(), property.name(), ((Integer)defaultValue).intValue(), property.comment()).getInt(((Integer)defaultValue).intValue());
        }
        if (defaultValue instanceof int[]) {
            return configuration.get(property.category(), property.name(), (int[])defaultValue, property.comment()).getIntList();
        }
        if (defaultValue instanceof String) {
            return configuration.get(property.category(), property.name(), (String)defaultValue, property.comment()).getString();
        }
        if (defaultValue instanceof String[]) {
            return configuration.get(property.category(), property.name(), (String[])defaultValue, property.comment()).getStringList();
        }
        throw new Exception("Config data class is unknown");
    }

    public Property findProperty(String category, String name) {
        if (this.config.getCategory(category) != null) {
            return this.config.getCategory(category).get(name);
        }
        return null;
    }

    public void saveConfig() {
        if (this.config != null && this.config.hasChanged()) {
            this.config.save();
        }
    }
}

