/*
 * Decompiled with CFR 0.152.
 */
package baubles.api.cap;

import baubles.api.IBauble;
import baubles.api.cap.IBaublesItemHandler;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;

public class BaublesContainer
extends ItemStackHandler
implements IBaublesItemHandler {
    private static final int BAUBLE_SLOTS = 7;
    private boolean[] changed = new boolean[7];
    private boolean blockEvents = false;

    public BaublesContainer() {
        super(7);
    }

    public void setSize(int size) {
        if (size < 7) {
            size = 7;
        }
        super.setSize(size);
        boolean[] old = this.changed;
        this.changed = new boolean[size];
        for (int i = 0; i < old.length && i < this.changed.length; ++i) {
            this.changed[i] = old[i];
        }
    }

    @Override
    public boolean isItemValidForSlot(int slot, ItemStack stack, EntityLivingBase player) {
        if (stack == null || !(stack.func_77973_b() instanceof IBauble) || !((IBauble)stack.func_77973_b()).canEquip(stack, player)) {
            return false;
        }
        return ((IBauble)stack.func_77973_b()).getBaubleType(stack).hasSlot(slot);
    }

    @Override
    public boolean isEventBlocked() {
        return this.blockEvents;
    }

    @Override
    public void setEventBlock(boolean blockEvents) {
        this.blockEvents = blockEvents;
    }

    protected void onContentsChanged(int slot) {
        this.setChanged(slot, true);
    }

    @Override
    public boolean isChanged(int slot) {
        return this.changed[slot];
    }

    @Override
    public void setChanged(int slot, boolean change) {
        this.changed[slot] = change;
    }
}

