/*
 * Decompiled with CFR 0.152.
 */
package com.insane.simplelabels.tile;

import com.insane.simplelabels.MessageLabelUpdate;
import com.insane.simplelabels.PacketHandler;
import com.insane.simplelabels.SimpleLabels;
import com.insane.simplelabels.Util;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import powercrystals.minefactoryreloaded.api.IDeepStorageUnit;

public class TileLabel
extends TileEntity
implements ITickable {
    private ItemStack storedItem;
    private ItemStack storedItemForRender;
    private IDeepStorageUnit dsu;
    private EnumFacing dsuDirection = null;
    private int placedDirection;
    private long clickTime = -20L;

    public void init(int meta) {
        this.dsuDirection = EnumFacing.func_82600_a((int)meta);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.dsu = this.getDSU();
            if (this.dsu != null && !ItemStack.func_77989_b((ItemStack)this.getLabelStack(false), (ItemStack)this.dsu.getStoredItemType())) {
                this.setLabelStack(this.dsu.getStoredItemType());
                this.func_70296_d();
                this.sendPacket();
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                this.field_145850_b.func_175656_a(this.field_174879_c, state);
            }
        }
    }

    public boolean onRightClick(boolean sneaking, EntityPlayer player) {
        int extractAmount;
        this.dsu = this.getDSU();
        if (this.dsu == null) {
            return false;
        }
        ItemStack stored = this.dsu.getStoredItemType();
        if (stored == null) {
            return false;
        }
        int n = extractAmount = sneaking ? stored.func_77976_d() : 1;
        if (extractAmount > stored.field_77994_a) {
            extractAmount = stored.field_77994_a;
        }
        ItemStack dropStack = stored.func_77946_l();
        dropStack.field_77994_a = extractAmount;
        Util.dropItemInWorld(this, player, dropStack, 0.02);
        this.dsu.setStoredItemCount(stored.field_77994_a - extractAmount);
        return true;
    }

    public void addFromPlayer(EntityPlayer player) {
        ItemStack heldStack = player.field_71071_by.func_70448_g();
        if (heldStack != null) {
            heldStack.field_77994_a -= this.addStack(heldStack);
            if (heldStack.field_77994_a == 0) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
            }
        }
        if (this.field_145850_b.func_82737_E() - this.clickTime < 10L) {
            InventoryPlayer playerInv = player.field_71071_by;
            for (int invSlot = 0; invSlot < playerInv.func_70302_i_(); ++invSlot) {
                ItemStack slotStack = playerInv.func_70301_a(invSlot);
                int input = this.addStack(slotStack);
                if (input <= 0) continue;
                slotStack.field_77994_a -= input;
                if (slotStack.field_77994_a != 0) continue;
                playerInv.func_70299_a(invSlot, (ItemStack)null);
            }
        }
        this.clickTime = this.field_145850_b.func_82737_E();
        SimpleLabels.proxy.updatePlayerInventory(player);
        this.func_70296_d();
    }

    private int addStack(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        this.dsu = this.getDSU();
        if (this.dsu == null) {
            return 0;
        }
        ItemStack stored = this.dsu.getStoredItemType();
        if (stored == null) {
            this.dsu.setStoredItemType(stack, stack.field_77994_a);
            return stack.field_77994_a;
        }
        if (stored.func_185136_b(stack) && ItemStack.func_77970_a((ItemStack)stored, (ItemStack)stack)) {
            int addAmount = stack.field_77994_a;
            if (this.dsu.getMaxStoredCount() < stored.field_77994_a + stack.field_77994_a) {
                addAmount = this.dsu.getMaxStoredCount() - stored.field_77994_a;
            }
            this.dsu.setStoredItemCount(stored.field_77994_a + addAmount);
            return addAmount;
        }
        return 0;
    }

    public void setPlacedDirection(int newDirection) {
        this.placedDirection = newDirection;
    }

    public int getPlacedDirection() {
        return this.placedDirection;
    }

    public IDeepStorageUnit getDSU() {
        BlockPos pos = new BlockPos(this.field_174879_c.func_177958_n() - this.dsuDirection.func_82601_c(), this.field_174879_c.func_177956_o() - this.dsuDirection.func_96559_d(), this.field_174879_c.func_177952_p() - this.dsuDirection.func_82599_e());
        TileEntity te = this.field_145850_b.func_175625_s(pos);
        if (te instanceof IDeepStorageUnit) {
            return (IDeepStorageUnit)this.field_145850_b.func_175625_s(pos);
        }
        return null;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.dsu == null ? super.getRenderBoundingBox() : ((TileEntity)this.dsu).getRenderBoundingBox();
    }

    private void sendPacket() {
        PacketHandler.INSTANCE.sendToDimension((IMessage)new MessageLabelUpdate(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.getLabelStack(false)), this.field_145850_b.field_73011_w.getDimension());
    }

    public ItemStack getLabelStack(boolean forRender) {
        return forRender ? this.storedItemForRender : this.storedItem;
    }

    public void setLabelStack(ItemStack inputStack) {
        if (this.field_145850_b != null) {
            this.dsu = this.getDSU();
        }
        if (inputStack != null) {
            this.storedItem = inputStack.func_77946_l();
            this.storedItemForRender = inputStack.func_77946_l();
            this.storedItemForRender.field_77994_a = 1;
        } else {
            this.storedItemForRender = null;
            this.storedItem = null;
        }
    }

    public EnumFacing getDsuDirection() {
        return this.dsuDirection;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), tag);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = this.func_189515_b(new NBTTagCompound());
        return tag;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound tag = pkt.func_148857_g();
        this.func_145839_a(tag);
        this.dsu = this.getDSU();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        NBTTagCompound labelTag = new NBTTagCompound();
        if (this.getLabelStack(false) != null) {
            NBTTagCompound item = new NBTTagCompound();
            item = this.getLabelStack(false).func_77955_b(item);
            item.func_74768_a("actualSize", this.getLabelStack((boolean)false).field_77994_a);
            labelTag.func_74782_a("storedItem", (NBTBase)item);
        }
        labelTag.func_74778_a("dsuDir", this.dsuDirection.func_176610_l());
        labelTag.func_74768_a("renderDirection", this.placedDirection);
        labelTag.func_74772_a("clickTime", this.clickTime);
        tag.func_74782_a("labelTag", (NBTBase)labelTag);
        return super.func_189515_b(tag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        NBTTagCompound labelTag = (NBTTagCompound)tag.func_74781_a("labelTag");
        if (labelTag.func_74764_b("storedItem")) {
            NBTTagCompound item = labelTag.func_74775_l("storedItem");
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)item);
            stack.field_77994_a = item.func_74762_e("actualSize");
            this.setLabelStack(stack);
        }
        this.dsuDirection = EnumFacing.func_176739_a((String)labelTag.func_74779_i("dsuDir"));
        this.placedDirection = labelTag.func_74762_e("renderDirection");
        this.clickTime = labelTag.func_74763_f("clickTime");
        super.func_145839_a(tag);
    }
}

