/*
 * Decompiled with CFR 0.152.
 */
package com.insane.simplelabels.block;

import com.google.common.collect.Lists;
import com.insane.simplelabels.tile.TileVastStorageUnit;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockVastStorageUnit
extends Block
implements ITileEntityProvider {
    public BlockVastStorageUnit() {
        super(Material.field_151576_e);
        this.func_149663_c("blockVSU");
        this.setRegistryName("blockVSU");
        this.func_149711_c(3.0f);
        GameRegistry.register((IForgeRegistryEntry)this);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileVastStorageUnit();
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileVastStorageUnit te = (TileVastStorageUnit)world.func_175625_s(pos);
        if (stack.func_77942_o() && te != null) {
            if (stack.func_77978_p().func_74764_b("storedItem")) {
                ItemStack stored = ItemStack.func_77949_a((NBTTagCompound)stack.func_77978_p().func_74775_l("storedItem"));
                int amount = stack.func_77978_p().func_74762_e("storedCount");
                te.setStoredItemType(stored, amount);
            } else {
                te.func_145839_a(stack.func_77978_p());
                te.func_174878_a(pos);
            }
        }
        super.func_180633_a(world, pos, state, placer, stack);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, @Nullable ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        worldIn.func_175698_g(pos);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileVastStorageUnit te = (TileVastStorageUnit)world.func_175625_s(pos);
        if (te != null) {
            ItemStack stack = new ItemStack((Block)this);
            if (te.getStoredItemType() != null) {
                NBTTagCompound tag = new NBTTagCompound();
                ItemStack stored = te.getStoredItemType();
                tag.func_74768_a("storedCount", stored.field_77994_a);
                tag.func_74782_a("storedItem", (NBTBase)stored.func_77955_b(new NBTTagCompound()));
                stack.func_77982_d(tag);
            }
            return Lists.newArrayList((Object[])new ItemStack[]{stack});
        }
        return Collections.emptyList();
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }
}

