/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.ingredients;

import java.awt.Color;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.color.ColorGetter;
import mezz.jei.startup.StackHelper;
import mezz.jei.util.ErrorUtil;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemStackHelper
implements IIngredientHelper<ItemStack> {
    private final StackHelper stackHelper;

    public ItemStackHelper(StackHelper stackHelper) {
        this.stackHelper = stackHelper;
    }

    @Override
    public List<ItemStack> expandSubtypes(List<ItemStack> contained) {
        return this.stackHelper.getAllSubtypes(contained);
    }

    @Override
    @Nullable
    public ItemStack getMatch(Iterable<ItemStack> ingredients, ItemStack toMatch) {
        return this.stackHelper.containsStack(ingredients, toMatch);
    }

    @Override
    public String getDisplayName(ItemStack ingredient) {
        return ErrorUtil.checkNotNull(ingredient.func_82833_r(), "itemStack.getDisplayName()");
    }

    @Override
    public String getUniqueId(ItemStack ingredient) {
        ErrorUtil.checkNotEmpty(ingredient);
        return this.stackHelper.getUniqueIdentifierForStack(ingredient);
    }

    @Override
    public String getWildcardId(ItemStack ingredient) {
        ErrorUtil.checkNotEmpty(ingredient);
        return this.stackHelper.getUniqueIdentifierForStack(ingredient, StackHelper.UidMode.WILDCARD);
    }

    @Override
    public String getModId(ItemStack ingredient) {
        ErrorUtil.checkNotEmpty(ingredient);
        Item item = ingredient.func_77973_b();
        ResourceLocation itemName = item.getRegistryName();
        if (itemName == null) {
            String stackInfo = this.getErrorInfo(ingredient);
            throw new IllegalStateException("item.getRegistryName() returned null for: " + stackInfo);
        }
        return itemName.func_110624_b();
    }

    @Override
    public String getDisplayModId(ItemStack ingredient) {
        ErrorUtil.checkNotEmpty(ingredient);
        Item item = ingredient.func_77973_b();
        String modId = item.getCreatorModId(ingredient);
        if (modId == null) {
            String stackInfo = this.getErrorInfo(ingredient);
            throw new IllegalStateException("item.getCreatorModId() returned null for: " + stackInfo);
        }
        return modId;
    }

    @Override
    public Iterable<Color> getColors(ItemStack ingredient) {
        return ColorGetter.getColors(ingredient, 2);
    }

    @Override
    public String getResourceId(ItemStack ingredient) {
        ErrorUtil.checkNotEmpty(ingredient);
        Item item = ingredient.func_77973_b();
        ResourceLocation itemName = item.getRegistryName();
        if (itemName == null) {
            String stackInfo = this.getErrorInfo(ingredient);
            throw new IllegalStateException("item.getRegistryName() returned null for: " + stackInfo);
        }
        return itemName.func_110623_a();
    }

    @Override
    public ItemStack cheatIngredient(ItemStack ingredient, boolean fullStack) {
        return ingredient;
    }

    @Override
    public ItemStack copyIngredient(ItemStack ingredient) {
        return ingredient.func_77946_l();
    }

    @Override
    public boolean isValidIngredient(ItemStack ingredient) {
        return !ingredient.func_190926_b();
    }

    @Override
    public boolean isIngredientOnServer(ItemStack ingredient) {
        Item item = ingredient.func_77973_b();
        return ForgeRegistries.ITEMS.containsValue((IForgeRegistryEntry)item);
    }

    @Override
    public String getErrorInfo(ItemStack ingredient) {
        return ErrorUtil.getItemStackInfo(ingredient);
    }
}

