/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.ingredients;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mezz.jei.Internal;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.ingredients.IngredientFilter;
import mezz.jei.ingredients.IngredientListElementFactory;
import mezz.jei.startup.IModIdHelper;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.IngredientSet;
import mezz.jei.util.Log;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionHelper;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.NonNullList;

public class IngredientRegistry
implements IIngredientRegistry {
    private final IModIdHelper modIdHelper;
    private final Map<Class, IngredientSet> ingredientsMap;
    private final ImmutableMap<Class, IIngredientHelper> ingredientHelperMap;
    private final ImmutableMap<Class, IIngredientRenderer> ingredientRendererMap;
    private final List<ItemStack> fuels = new ArrayList<ItemStack>();
    private final List<ItemStack> potionIngredients = new ArrayList<ItemStack>();

    public IngredientRegistry(IModIdHelper modIdHelper, Map<Class, IngredientSet> ingredientsMap, ImmutableMap<Class, IIngredientHelper> ingredientHelperMap, ImmutableMap<Class, IIngredientRenderer> ingredientRendererMap) {
        this.modIdHelper = modIdHelper;
        this.ingredientsMap = ingredientsMap;
        this.ingredientHelperMap = ingredientHelperMap;
        this.ingredientRendererMap = ingredientRendererMap;
        for (ItemStack itemStack : this.getAllIngredients(ItemStack.class)) {
            this.getStackProperties(itemStack);
        }
    }

    private void getStackProperties(ItemStack itemStack) {
        String itemStackInfo;
        try {
            if (TileEntityFurnace.func_145954_b((ItemStack)itemStack)) {
                this.fuels.add(itemStack);
            }
        }
        catch (LinkageError | RuntimeException e) {
            itemStackInfo = ErrorUtil.getItemStackInfo(itemStack);
            Log.get().error("Failed to check if item is fuel {}.", (Object)itemStackInfo, (Object)e);
        }
        try {
            if (PotionHelper.func_185205_a((ItemStack)itemStack)) {
                this.potionIngredients.add(itemStack);
            }
        }
        catch (LinkageError | RuntimeException e) {
            itemStackInfo = ErrorUtil.getItemStackInfo(itemStack);
            Log.get().error("Failed to check if item is a potion ingredient {}.", (Object)itemStackInfo, (Object)e);
        }
    }

    @Override
    public <V> List<V> getIngredients(Class<V> ingredientClass) {
        ErrorUtil.checkNotNull(ingredientClass, "ingredientClass");
        IngredientSet ingredients = this.ingredientsMap.get(ingredientClass);
        if (ingredients == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Collection)ingredients);
    }

    @Override
    public <V> Collection<V> getAllIngredients(Class<V> ingredientClass) {
        IngredientSet ingredients = this.ingredientsMap.get(ingredientClass);
        if (ingredients == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableCollection(ingredients);
    }

    public <V> boolean isValidIngredient(V ingredient) {
        IIngredientHelper ingredientHelper = (IIngredientHelper)this.ingredientHelperMap.get(ingredient.getClass());
        return ingredientHelper != null && ingredientHelper.isValidIngredient(ingredient);
    }

    @Override
    public <V> IIngredientHelper<V> getIngredientHelper(V ingredient) {
        ErrorUtil.checkNotNull(ingredient, "ingredient");
        return this.getIngredientHelper(ingredient.getClass());
    }

    @Override
    public <V> IIngredientHelper<V> getIngredientHelper(Class<? extends V> ingredientClass) {
        ErrorUtil.checkNotNull(ingredientClass, "ingredientClass");
        IIngredientHelper ingredientHelper = (IIngredientHelper)this.ingredientHelperMap.get(ingredientClass);
        if (ingredientHelper == null) {
            throw new IllegalArgumentException("Unknown ingredient type: " + ingredientClass);
        }
        return ingredientHelper;
    }

    @Override
    public <V> IIngredientRenderer<V> getIngredientRenderer(V ingredient) {
        ErrorUtil.checkNotNull(ingredient, "ingredient");
        Class<?> ingredientClass = ingredient.getClass();
        return this.getIngredientRenderer(ingredientClass);
    }

    @Override
    public <V> IIngredientRenderer<V> getIngredientRenderer(Class<? extends V> ingredientClass) {
        ErrorUtil.checkNotNull(ingredientClass, "ingredientClass");
        IIngredientRenderer ingredientRenderer = (IIngredientRenderer)this.ingredientRendererMap.get(ingredientClass);
        if (ingredientRenderer == null) {
            throw new IllegalArgumentException("Could not find ingredient renderer for " + ingredientClass);
        }
        return ingredientRenderer;
    }

    @Override
    public Collection<Class> getRegisteredIngredientClasses() {
        return Collections.unmodifiableCollection(this.ingredientsMap.keySet());
    }

    @Override
    public List<ItemStack> getFuels() {
        return Collections.unmodifiableList(this.fuels);
    }

    @Override
    public List<ItemStack> getPotionIngredients() {
        return Collections.unmodifiableList(this.potionIngredients);
    }

    @Override
    public <V> void addIngredientsAtRuntime(Class<V> ingredientClass, List<V> ingredients) {
        ErrorUtil.assertMainThread();
        this.addIngredientsAtRuntime(ingredientClass, ingredients, Internal.getIngredientFilter());
    }

    @Override
    public <V> void addIngredientsAtRuntime(Class<V> ingredientClass, Collection<V> ingredients) {
        ErrorUtil.assertMainThread();
        this.addIngredientsAtRuntime(ingredientClass, ingredients, Internal.getIngredientFilter());
    }

    public <V> void addIngredientsAtRuntime(Class<V> ingredientClass, Collection<V> ingredients, IngredientFilter ingredientFilter) {
        ErrorUtil.checkNotNull(ingredientClass, "ingredientClass");
        ErrorUtil.checkNotEmpty(ingredients, "ingredients");
        IIngredientHelper ingredientHelper = this.getIngredientHelper(ingredientClass);
        Set set = this.ingredientsMap.computeIfAbsent(ingredientClass, k -> IngredientSet.create(ingredientClass, ingredientHelper));
        ArrayList<V> newIngredients = new ArrayList<V>(ingredients.size());
        for (V ingredient : ingredients) {
            if (set.add(ingredient)) {
                newIngredients.add(ingredient);
            }
            if (!(ingredient instanceof ItemStack)) continue;
            this.getStackProperties((ItemStack)ingredient);
        }
        if (!newIngredients.isEmpty()) {
            NonNullList<IIngredientListElement> ingredientListElements = IngredientListElementFactory.createList(this, ingredientClass, newIngredients, this.modIdHelper);
            ingredientFilter.addIngredients(ingredientListElements);
        }
    }

    @Override
    public <V> void removeIngredientsAtRuntime(Class<V> ingredientClass, List<V> ingredients) {
        ErrorUtil.assertMainThread();
        this.removeIngredientsAtRuntime(ingredientClass, ingredients, Internal.getIngredientFilter());
    }

    @Override
    public <V> void removeIngredientsAtRuntime(Class<V> ingredientClass, Collection<V> ingredients) {
        ErrorUtil.assertMainThread();
        this.removeIngredientsAtRuntime(ingredientClass, ingredients, Internal.getIngredientFilter());
    }

    public <V> void removeIngredientsAtRuntime(Class<V> ingredientClass, Collection<V> ingredients, IngredientFilter ingredientFilter) {
        ErrorUtil.checkNotNull(ingredientClass, "ingredientClass");
        ErrorUtil.checkNotEmpty(ingredients, "ingredients");
        IngredientSet set = this.ingredientsMap.get(ingredientClass);
        if (set != null) {
            set.removeAll(ingredients);
        }
        NonNullList<IIngredientListElement> ingredientListElements = IngredientListElementFactory.createList(this, ingredientClass, ingredients, this.modIdHelper);
        ingredientFilter.removeIngredients(ingredientListElements);
    }
}

