/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay;

import java.awt.Rectangle;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.JustEnoughItems;
import mezz.jei.config.Config;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.ingredients.GuiItemStackGroup;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.input.ClickedIngredient;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.input.IPaged;
import mezz.jei.input.IShowsRecipeFocuses;
import mezz.jei.input.MouseHelper;
import mezz.jei.network.packets.PacketDeletePlayerItem;
import mezz.jei.render.IngredientListBatchRenderer;
import mezz.jei.render.IngredientListSlot;
import mezz.jei.render.IngredientRenderer;
import mezz.jei.runtime.JeiRuntime;
import mezz.jei.util.GiveMode;
import mezz.jei.util.MathUtil;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class IngredientGrid
implements IShowsRecipeFocuses,
IPaged {
    private static final int INGREDIENT_PADDING = 1;
    private static final int INGREDIENT_WIDTH = GuiItemStackGroup.getWidth(1);
    private static final int INGREDIENT_HEIGHT = GuiItemStackGroup.getHeight(1);
    private Rectangle area = new Rectangle();
    protected final IngredientListBatchRenderer guiIngredientSlots = new IngredientListBatchRenderer();

    public void updateBounds(Rectangle area, Collection<Rectangle> exclusionAreas) {
        int columns = area.width / INGREDIENT_WIDTH;
        int rows = area.height / INGREDIENT_HEIGHT;
        int width = columns * INGREDIENT_WIDTH;
        int height = rows * INGREDIENT_HEIGHT;
        int x = area.x + (area.width - width) / 2;
        int y = area.y + (area.height - height) / 2;
        this.area = new Rectangle(x, y, width, height);
        this.guiIngredientSlots.clear();
        for (int row = 0; row < rows; ++row) {
            int y1 = y + row * INGREDIENT_HEIGHT;
            for (int column = 0; column < columns; ++column) {
                int x1 = x + column * INGREDIENT_WIDTH;
                IngredientListSlot ingredientListSlot = new IngredientListSlot(x1, y1, 1);
                Rectangle stackArea = ingredientListSlot.getArea();
                boolean blocked = MathUtil.intersects(exclusionAreas, stackArea);
                ingredientListSlot.setBlocked(blocked);
                this.guiIngredientSlots.add(ingredientListSlot);
            }
        }
    }

    public void updateLayout(Collection<Rectangle> guiExclusionAreas) {
        for (IngredientListSlot ingredientListSlot : this.guiIngredientSlots.getAllGuiIngredientSlots()) {
            Rectangle stackArea = ingredientListSlot.getArea();
            boolean blocked = MathUtil.intersects(guiExclusionAreas, stackArea);
            ingredientListSlot.setBlocked(blocked);
        }
    }

    public Rectangle getArea() {
        return this.area;
    }

    public void draw(Minecraft minecraft, int mouseX, int mouseY) {
        IngredientRenderer hovered;
        GlStateManager.func_179084_k();
        this.guiIngredientSlots.render(minecraft);
        if (!this.shouldDeleteItemOnClick(minecraft, mouseX, mouseY) && this.isMouseOver(mouseX, mouseY) && (hovered = this.guiIngredientSlots.getHovered(mouseX, mouseY)) != null) {
            hovered.drawHighlight();
        }
        GlStateManager.func_179141_d();
    }

    public void drawTooltips(Minecraft minecraft, int mouseX, int mouseY) {
        if (this.isMouseOver(mouseX, mouseY)) {
            if (this.shouldDeleteItemOnClick(minecraft, mouseX, mouseY)) {
                String deleteItem = Translator.translateToLocal("jei.tooltip.delete.item");
                TooltipRenderer.drawHoveringText(minecraft, deleteItem, mouseX, mouseY);
            } else {
                IngredientRenderer hovered = this.guiIngredientSlots.getHovered(mouseX, mouseY);
                if (hovered != null) {
                    hovered.drawTooltip(minecraft, mouseX, mouseY);
                }
            }
        }
    }

    private boolean shouldDeleteItemOnClick(Minecraft minecraft, int mouseX, int mouseY) {
        if (Config.isDeleteItemsInCheatModeActive()) {
            JeiRuntime runtime;
            EntityPlayerSP player = minecraft.field_71439_g;
            ItemStack itemStack = player.field_71071_by.func_70445_o();
            if (!(itemStack.func_190926_b() || (runtime = Internal.getRuntime()) != null && runtime.getRecipesGui().isOpen())) {
                ItemStack value;
                IClickedIngredient<?> ingredientUnderMouse;
                GiveMode giveMode = Config.getGiveMode();
                return giveMode != GiveMode.MOUSE_PICKUP || (ingredientUnderMouse = this.getIngredientUnderMouse(mouseX, mouseY)) == null || !(ingredientUnderMouse.getValue() instanceof ItemStack) || !ItemHandlerHelper.canItemStacksStack((ItemStack)itemStack, (ItemStack)(value = (ItemStack)ingredientUnderMouse.getValue()));
            }
        }
        return false;
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        return this.area.contains(mouseX, mouseY);
    }

    public boolean handleMouseClicked(int mouseX, int mouseY) {
        Minecraft minecraft;
        if (this.isMouseOver(mouseX, mouseY) && this.shouldDeleteItemOnClick(minecraft = Minecraft.func_71410_x(), mouseX, mouseY)) {
            EntityPlayerSP player = minecraft.field_71439_g;
            ItemStack itemStack = player.field_71071_by.func_70445_o();
            if (!itemStack.func_190926_b()) {
                player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                PacketDeletePlayerItem packet = new PacketDeletePlayerItem(itemStack);
                JustEnoughItems.getProxy().sendPacketToServer(packet);
                return true;
            }
        }
        return false;
    }

    @Nullable
    public IIngredientListElement getElementUnderMouse() {
        IngredientRenderer hovered = this.guiIngredientSlots.getHovered(MouseHelper.getX(), MouseHelper.getY());
        if (hovered != null) {
            return hovered.getElement();
        }
        return null;
    }

    @Override
    @Nullable
    public IClickedIngredient<?> getIngredientUnderMouse(int mouseX, int mouseY) {
        if (this.isMouseOver(mouseX, mouseY)) {
            ClickedIngredient<?> clicked = this.guiIngredientSlots.getIngredientUnderMouse(mouseX, mouseY);
            if (clicked != null) {
                clicked.setAllowsCheating();
            }
            return clicked;
        }
        return null;
    }

    @Override
    public boolean canSetFocusWithMouse() {
        return true;
    }

    public abstract int getPageCount();

    public abstract int getPageNum();

    public abstract List<IIngredientListElement> getVisibleElements();
}

