/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.util.NEIClientUtils;
import codechicken.nei.widget.Button;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ChatAllowedCharacters;
import org.lwjgl.input.Keyboard;

public abstract class SaveLoadButton
extends Button {
    public boolean saved;
    public long backdowntime;
    public int backs;
    public int cursorCounter;
    public boolean focused;

    public SaveLoadButton(String s) {
        super(s);
    }

    @Override
    public boolean handleClick(int mousex, int mousey, int button) {
        if (button == 1) {
            this.label = "";
            this.onTextChange();
            this.focused = true;
            NEIClientUtils.playClickSound();
            return true;
        }
        return super.handleClick(mousex, mousey, button);
    }

    public abstract void onTextChange();

    @Override
    public void onGuiClick(int i, int j) {
        if (!this.contains(i, j)) {
            this.focused = false;
        }
    }

    @Override
    public boolean handleKeyPress(int keyID, char keyChar) {
        if (!this.focused) {
            return false;
        }
        if (keyID == 14) {
            if (this.label.length() > 0) {
                this.label = this.label.substring(0, this.label.length() - 1);
                this.onTextChange();
                this.backdowntime = System.currentTimeMillis();
            }
        } else if (keyID == 28) {
            this.focused = false;
        } else if (keyChar == '\u0016') {
            String pastestring = GuiScreen.func_146277_j();
            if (pastestring == null) {
                pastestring = "";
            }
            this.label = this.label + pastestring;
            this.onTextChange();
        } else if (ChatAllowedCharacters.func_71566_a((char)keyChar)) {
            this.label = this.label + keyChar;
            this.onTextChange();
        }
        return true;
    }

    @Override
    public void update() {
        ++this.cursorCounter;
        if (this.backdowntime > 0L) {
            if (Keyboard.isKeyDown((int)14) && this.label.length() > 5) {
                if ((float)(System.currentTimeMillis() - this.backdowntime) > 200.0f / (1.0f + (float)this.backs * 0.3f)) {
                    this.label = this.label.substring(0, this.label.length() - 1);
                    this.onTextChange();
                    this.backdowntime = System.currentTimeMillis();
                    ++this.backs;
                }
            } else {
                this.backdowntime = 0L;
                this.backs = 0;
            }
        }
    }

    @Override
    public void draw(int mousex, int mousey) {
        super.draw(mousex, mousey);
        if (this.focused && this.cursorCounter / 6 % 2 == 0) {
            GuiDraw.drawString((String)"_", (int)(this.x + (this.w + GuiDraw.getStringWidth((String)this.getRenderLabel())) / 2), (int)(this.y + (this.h - 8) / 2), (int)-1);
        }
    }

    @Override
    public String getRenderLabel() {
        return NEIClientUtils.translate(this.saved ? "load" : "save", new Object[0]) + " " + this.label;
    }
}

