/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import io.netty.buffer.ByteBuf;
import mekanism.api.Coord4D;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.base.TileNetworkList;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.content.transporter.TransporterFilter;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityDigitalMiner;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.tile.TileEntityOredictionificator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketNewFilter
implements IMessageHandler<NewFilterMessage, IMessage> {
    public IMessage onMessage(NewFilterMessage message, MessageContext context) {
        WorldServer worldServer = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(message.coord4D.dimensionId);
        worldServer.func_152344_a(() -> {
            block3: {
                block5: {
                    block4: {
                        if (worldServer == null) break block3;
                        if (message.type != 0 || !(message.coord4D.getTileEntity((IBlockAccess)worldServer) instanceof TileEntityLogisticalSorter)) break block4;
                        TileEntityLogisticalSorter sorter = (TileEntityLogisticalSorter)message.coord4D.getTileEntity((IBlockAccess)worldServer);
                        sorter.filters.add(message.tFilter);
                        for (EntityPlayer iterPlayer : sorter.playersUsing) {
                            Mekanism.packetHandler.sendTo(new PacketTileEntity.TileEntityMessage(Coord4D.get(sorter), sorter.getFilterPacket(new TileNetworkList())), (EntityPlayerMP)iterPlayer);
                        }
                        break block3;
                    }
                    if (message.type != 1 || !(message.coord4D.getTileEntity((IBlockAccess)worldServer) instanceof TileEntityDigitalMiner)) break block5;
                    TileEntityDigitalMiner miner = (TileEntityDigitalMiner)message.coord4D.getTileEntity((IBlockAccess)worldServer);
                    miner.filters.add(message.mFilter);
                    for (EntityPlayer iterPlayer : miner.playersUsing) {
                        Mekanism.packetHandler.sendTo(new PacketTileEntity.TileEntityMessage(Coord4D.get(miner), miner.getFilterPacket(new TileNetworkList())), (EntityPlayerMP)iterPlayer);
                    }
                    break block3;
                }
                if (message.type != 2 || !(message.coord4D.getTileEntity((IBlockAccess)worldServer) instanceof TileEntityOredictionificator)) break block3;
                TileEntityOredictionificator oredictionificator = (TileEntityOredictionificator)message.coord4D.getTileEntity((IBlockAccess)worldServer);
                oredictionificator.filters.add(message.oFilter);
                for (EntityPlayer iterPlayer : oredictionificator.playersUsing) {
                    Mekanism.packetHandler.sendTo(new PacketTileEntity.TileEntityMessage(Coord4D.get(oredictionificator), oredictionificator.getFilterPacket(new TileNetworkList())), (EntityPlayerMP)iterPlayer);
                }
            }
        });
        return null;
    }

    public static class NewFilterMessage
    implements IMessage {
        public Coord4D coord4D;
        public TransporterFilter tFilter;
        public MinerFilter mFilter;
        public TileEntityOredictionificator.OredictionificatorFilter oFilter;
        public byte type = (byte)-1;

        public NewFilterMessage() {
        }

        public NewFilterMessage(Coord4D coord, Object filter) {
            this.coord4D = coord;
            if (filter instanceof TransporterFilter) {
                this.tFilter = (TransporterFilter)filter;
                this.type = 0;
            } else if (filter instanceof MinerFilter) {
                this.mFilter = (MinerFilter)filter;
                this.type = 1;
            } else if (filter instanceof TileEntityOredictionificator.OredictionificatorFilter) {
                this.oFilter = (TileEntityOredictionificator.OredictionificatorFilter)filter;
                this.type = (byte)2;
            }
        }

        public void toBytes(ByteBuf dataStream) {
            this.coord4D.write(dataStream);
            dataStream.writeByte((int)this.type);
            TileNetworkList data = new TileNetworkList();
            if (this.type == 0) {
                this.tFilter.write(data);
            } else if (this.type == 1) {
                this.mFilter.write(data);
            } else if (this.type == 2) {
                this.oFilter.write(data);
            }
            PacketHandler.encode(data.toArray(), dataStream);
        }

        public void fromBytes(ByteBuf dataStream) {
            this.coord4D = Coord4D.read(dataStream);
            this.type = dataStream.readByte();
            if (this.type == 0) {
                this.tFilter = TransporterFilter.readFromPacket(dataStream);
            } else if (this.type == 1) {
                this.mFilter = MinerFilter.readFromPacket(dataStream);
            } else if (this.type == 2) {
                this.oFilter = TileEntityOredictionificator.OredictionificatorFilter.readFromPacket(dataStream);
            }
        }
    }
}

