/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block.states;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import javax.annotation.Nullable;
import mekanism.common.Mekanism;
import mekanism.common.MekanismBlocks;
import mekanism.common.Tier;
import mekanism.common.block.BlockBasic;
import mekanism.common.block.states.BlockStateFacing;
import mekanism.common.tile.TileEntityBin;
import mekanism.common.tile.TileEntityBoilerCasing;
import mekanism.common.tile.TileEntityBoilerValve;
import mekanism.common.tile.TileEntityDynamicTank;
import mekanism.common.tile.TileEntityDynamicValve;
import mekanism.common.tile.TileEntityInductionCasing;
import mekanism.common.tile.TileEntityInductionCell;
import mekanism.common.tile.TileEntityInductionPort;
import mekanism.common.tile.TileEntityInductionProvider;
import mekanism.common.tile.TileEntityPressureDisperser;
import mekanism.common.tile.TileEntitySecurityDesk;
import mekanism.common.tile.TileEntityStructuralGlass;
import mekanism.common.tile.TileEntitySuperheatingElement;
import mekanism.common.tile.TileEntityThermalEvaporationBlock;
import mekanism.common.tile.TileEntityThermalEvaporationController;
import mekanism.common.tile.TileEntityThermalEvaporationValve;
import mekanism.common.util.LangUtils;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class BlockStateBasic
extends ExtendedBlockState {
    public static final PropertyBool activeProperty = PropertyBool.func_177716_a((String)"active");
    public static final PropertyEnum<Tier.BaseTier> tierProperty = PropertyEnum.func_177709_a((String)"tier", Tier.BaseTier.class);

    public BlockStateBasic(BlockBasic block, PropertyEnum<BasicBlockType> typeProperty) {
        super((Block)block, new IProperty[]{BlockStateFacing.facingProperty, typeProperty, activeProperty, tierProperty}, new IUnlistedProperty[0]);
    }

    public static class BasicBlockStateMapper
    extends StateMapperBase {
        protected ModelResourceLocation func_178132_a(IBlockState state) {
            BlockBasic block = (BlockBasic)state.func_177230_c();
            BasicBlockType type = (BasicBlockType)((Object)state.func_177229_b(block.getTypeProperty()));
            StringBuilder builder = new StringBuilder();
            String nameOverride = null;
            if (type.hasActiveTexture()) {
                builder.append(activeProperty.func_177701_a());
                builder.append("=");
                builder.append(state.func_177229_b((IProperty)activeProperty));
            }
            if (type.hasRotations()) {
                EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockStateFacing.facingProperty);
                if (!type.canRotateTo(facing)) {
                    facing = EnumFacing.NORTH;
                }
                if (builder.length() > 0) {
                    builder.append(",");
                }
                builder.append(BlockStateFacing.facingProperty.func_177701_a());
                builder.append("=");
                builder.append(facing.func_176610_l());
            }
            if (type.tiers) {
                Tier.BaseTier tier = (Tier.BaseTier)((Object)state.func_177229_b(tierProperty));
                if (tier == Tier.BaseTier.CREATIVE && type != BasicBlockType.BIN) {
                    tier = Tier.BaseTier.ULTIMATE;
                }
                nameOverride = type.func_176610_l() + "_" + tier.func_176610_l();
            }
            if (builder.length() == 0) {
                builder.append("normal");
            }
            ResourceLocation baseLocation = new ResourceLocation("mekanism", nameOverride != null ? nameOverride : type.func_176610_l());
            return new ModelResourceLocation(baseLocation, builder.toString());
        }
    }

    public static class BasicBlockPredicate
    implements Predicate<BasicBlockType> {
        public BasicBlock basicBlock;

        public BasicBlockPredicate(BasicBlock type) {
            this.basicBlock = type;
        }

        public boolean apply(BasicBlockType input) {
            return input.blockType == this.basicBlock;
        }
    }

    public static enum BasicBlockType implements IStringSerializable
    {
        OSMIUM_BLOCK(BasicBlock.BASIC_BLOCK_1, 0, "OsmiumBlock", null, false, (Predicate<EnumFacing>)Predicates.alwaysFalse(), false, false, true),
        BRONZE_BLOCK(BasicBlock.BASIC_BLOCK_1, 1, "BronzeBlock", null, false, (Predicate<EnumFacing>)Predicates.alwaysFalse(), false, false, true),
        REFINED_OBSIDIAN(BasicBlock.BASIC_BLOCK_1, 2, "RefinedObsidian", null, false, (Predicate<EnumFacing>)Predicates.alwaysFalse(), false, false, true),
        COAL_BLOCK(BasicBlock.BASIC_BLOCK_1, 3, "CharcoalBlock", null, false, (Predicate<EnumFacing>)Predicates.alwaysFalse(), false, false, false),
        REFINED_GLOWSTONE(BasicBlock.BASIC_BLOCK_1, 4, "RefinedGlowstone", null, false, (Predicate<EnumFacing>)Predicates.alwaysFalse(), false, false, true),
        STEEL_BLOCK(BasicBlock.BASIC_BLOCK_1, 5, "SteelBlock", null, false, (Predicate<EnumFacing>)Predicates.alwaysFalse(), false, false, true),
        BIN(BasicBlock.BASIC_BLOCK_1, 6, "Bin", TileEntityBin.class, true, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, true, true, false),
        TELEPORTER_FRAME(BasicBlock.BASIC_BLOCK_1, 7, "TeleporterFrame", null, true, (Predicate<EnumFacing>)Predicates.alwaysFalse(), false, false, false),
        STEEL_CASING(BasicBlock.BASIC_BLOCK_1, 8, "SteelCasing", null, true, (Predicate<EnumFacing>)Predicates.alwaysFalse(), false, false, false),
        DYNAMIC_TANK(BasicBlock.BASIC_BLOCK_1, 9, "DynamicTank", TileEntityDynamicTank.class, true, (Predicate<EnumFacing>)Predicates.alwaysFalse(), false, false, false),
        STRUCTURAL_GLASS(BasicBlock.BASIC_BLOCK_1, 10, "StructuralGlass", TileEntityStructuralGlass.class, true, (Predicate<EnumFacing>)Predicates.alwaysFalse(), false, false, false),
        DYNAMIC_VALVE(BasicBlock.BASIC_BLOCK_1, 11, "DynamicValve", TileEntityDynamicValve.class, true, (Predicate<EnumFacing>)Predicates.alwaysFalse(), false, false, false),
        COPPER_BLOCK(BasicBlock.BASIC_BLOCK_1, 12, "CopperBlock", null, false, (Predicate<EnumFacing>)Predicates.alwaysFalse(), false, false, true),
        TIN_BLOCK(BasicBlock.BASIC_BLOCK_1, 13, "TinBlock", null, false, (Predicate<EnumFacing>)Predicates.alwaysFalse(), false, false, true),
        THERMAL_EVAPORATION_CONTROLLER(BasicBlock.BASIC_BLOCK_1, 14, "ThermalEvaporationController", TileEntityThermalEvaporationController.class, true, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, true, false, false),
        THERMAL_EVAPORATION_VALVE(BasicBlock.BASIC_BLOCK_1, 15, "ThermalEvaporationValve", TileEntityThermalEvaporationValve.class, true, (Predicate<EnumFacing>)Predicates.alwaysFalse(), false, false, false),
        THERMAL_EVAPORATION_BLOCK(BasicBlock.BASIC_BLOCK_2, 0, "ThermalEvaporationBlock", TileEntityThermalEvaporationBlock.class, true, (Predicate<EnumFacing>)Predicates.alwaysFalse(), false, false, false),
        INDUCTION_CASING(BasicBlock.BASIC_BLOCK_2, 1, "InductionCasing", TileEntityInductionCasing.class, true, (Predicate<EnumFacing>)Predicates.alwaysFalse(), false, false, false),
        INDUCTION_PORT(BasicBlock.BASIC_BLOCK_2, 2, "InductionPort", TileEntityInductionPort.class, true, (Predicate<EnumFacing>)Predicates.alwaysFalse(), true, false, false),
        INDUCTION_CELL(BasicBlock.BASIC_BLOCK_2, 3, "InductionCell", TileEntityInductionCell.class, true, (Predicate<EnumFacing>)Predicates.alwaysFalse(), false, true, false),
        INDUCTION_PROVIDER(BasicBlock.BASIC_BLOCK_2, 4, "InductionProvider", TileEntityInductionProvider.class, true, (Predicate<EnumFacing>)Predicates.alwaysFalse(), false, true, false),
        SUPERHEATING_ELEMENT(BasicBlock.BASIC_BLOCK_2, 5, "SuperheatingElement", TileEntitySuperheatingElement.class, true, (Predicate<EnumFacing>)Predicates.alwaysFalse(), false, false, false),
        PRESSURE_DISPERSER(BasicBlock.BASIC_BLOCK_2, 6, "PressureDisperser", TileEntityPressureDisperser.class, true, (Predicate<EnumFacing>)Predicates.alwaysFalse(), false, false, false),
        BOILER_CASING(BasicBlock.BASIC_BLOCK_2, 7, "BoilerCasing", TileEntityBoilerCasing.class, true, (Predicate<EnumFacing>)Predicates.alwaysFalse(), false, false, false),
        BOILER_VALVE(BasicBlock.BASIC_BLOCK_2, 8, "BoilerValve", TileEntityBoilerValve.class, true, (Predicate<EnumFacing>)Predicates.alwaysFalse(), false, false, false),
        SECURITY_DESK(BasicBlock.BASIC_BLOCK_2, 9, "SecurityDesk", TileEntitySecurityDesk.class, true, (Predicate<EnumFacing>)EnumFacing.Plane.HORIZONTAL, false, false, false);

        public BasicBlock blockType;
        public int meta;
        public String name;
        public Class<? extends TileEntity> tileEntityClass;
        public boolean isElectric;
        public boolean hasDescription;
        public Predicate<EnumFacing> facingPredicate;
        public boolean activable;
        public boolean tiers;
        public boolean isBeaconBase;

        private BasicBlockType(BasicBlock block, int metadata, String s, Class<? extends TileEntity> tileClass, boolean hasDesc, Predicate<EnumFacing> facingAllowed, boolean activeState, boolean t, boolean beaconBase) {
            this.blockType = block;
            this.meta = metadata;
            this.name = s;
            this.tileEntityClass = tileClass;
            this.hasDescription = hasDesc;
            this.facingPredicate = facingAllowed;
            this.activable = activeState;
            this.tiers = t;
            this.isBeaconBase = beaconBase;
        }

        @Nullable
        public static BasicBlockType get(IBlockState state) {
            if (state.func_177230_c() instanceof BlockBasic) {
                return (BasicBlockType)((Object)state.func_177229_b(((BlockBasic)state.func_177230_c()).getTypeProperty()));
            }
            return null;
        }

        @Nullable
        public static BasicBlockType get(ItemStack stack) {
            return BasicBlockType.get(Block.func_149634_a((Item)stack.func_77973_b()), stack.func_77952_i());
        }

        @Nullable
        public static BasicBlockType get(Block block, int meta) {
            if (block instanceof BlockBasic) {
                return BasicBlockType.get(((BlockBasic)block).getBasicBlock(), meta);
            }
            return null;
        }

        @Nullable
        public static BasicBlockType get(BasicBlock blockType, int metadata) {
            int index = blockType.ordinal() << 4 | metadata;
            if (index < BasicBlockType.values().length) {
                BasicBlockType firstTry = BasicBlockType.values()[index];
                if (firstTry.blockType == blockType && firstTry.meta == metadata) {
                    return firstTry;
                }
            }
            for (BasicBlockType type : BasicBlockType.values()) {
                if (type.blockType != blockType || type.meta != metadata) continue;
                return type;
            }
            Mekanism.logger.error("Invalid BasicBlock. type: {}, meta: {}", (Object)blockType.ordinal(), (Object)metadata);
            return null;
        }

        public TileEntity create() {
            try {
                return this.tileEntityClass.newInstance();
            }
            catch (Exception e) {
                Mekanism.logger.error("Unable to indirectly create tile entity.");
                e.printStackTrace();
                return null;
            }
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public String getDescription() {
            return LangUtils.localize("tooltip." + this.name);
        }

        public ItemStack getStack(int amount) {
            return new ItemStack(this.blockType.getBlock(), amount, this.meta);
        }

        public boolean canRotateTo(EnumFacing side) {
            return this.facingPredicate.apply((Object)side);
        }

        public boolean hasRotations() {
            return !this.facingPredicate.equals((Object)Predicates.alwaysFalse());
        }

        public boolean hasActiveTexture() {
            return this.activable;
        }
    }

    public static enum BasicBlock {
        BASIC_BLOCK_1,
        BASIC_BLOCK_2;

        private PropertyEnum<BasicBlockType> predicatedProperty;

        public PropertyEnum<BasicBlockType> getProperty() {
            if (this.predicatedProperty == null) {
                this.predicatedProperty = PropertyEnum.func_177708_a((String)"type", BasicBlockType.class, (Predicate)new BasicBlockPredicate(this));
            }
            return this.predicatedProperty;
        }

        public Block getBlock() {
            switch (this) {
                case BASIC_BLOCK_1: {
                    return MekanismBlocks.BasicBlock;
                }
                case BASIC_BLOCK_2: {
                    return MekanismBlocks.BasicBlock2;
                }
            }
            return null;
        }
    }
}

