/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import mekanism.api.Range4D;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.network.PacketBoxBlacklist;
import mekanism.common.network.PacketConfigSync;
import mekanism.common.network.PacketConfigurationUpdate;
import mekanism.common.network.PacketContainerEditMode;
import mekanism.common.network.PacketDataRequest;
import mekanism.common.network.PacketDigitalMinerGui;
import mekanism.common.network.PacketDropperUse;
import mekanism.common.network.PacketEditFilter;
import mekanism.common.network.PacketEntityMove;
import mekanism.common.network.PacketFlamethrowerData;
import mekanism.common.network.PacketFreeRunnerData;
import mekanism.common.network.PacketItemStack;
import mekanism.common.network.PacketJetpackData;
import mekanism.common.network.PacketKey;
import mekanism.common.network.PacketLogisticalSorterGui;
import mekanism.common.network.PacketNewFilter;
import mekanism.common.network.PacketOredictionificatorGui;
import mekanism.common.network.PacketPersonalChest;
import mekanism.common.network.PacketPortableTeleporter;
import mekanism.common.network.PacketPortalFX;
import mekanism.common.network.PacketRedstoneControl;
import mekanism.common.network.PacketRemoveUpgrade;
import mekanism.common.network.PacketRobit;
import mekanism.common.network.PacketScubaTankData;
import mekanism.common.network.PacketSecurityMode;
import mekanism.common.network.PacketSecurityUpdate;
import mekanism.common.network.PacketSimpleGui;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.network.PacketTransmitterUpdate;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class PacketHandler {
    public SimpleNetworkWrapper netHandler = NetworkRegistry.INSTANCE.newSimpleChannel("MEK");

    public void initialize() {
        this.netHandler.registerMessage(PacketRobit.class, PacketRobit.RobitMessage.class, 0, Side.SERVER);
        this.netHandler.registerMessage(PacketTransmitterUpdate.class, PacketTransmitterUpdate.TransmitterUpdateMessage.class, 1, Side.CLIENT);
        this.netHandler.registerMessage(PacketPersonalChest.class, PacketPersonalChest.PersonalChestMessage.class, 2, Side.CLIENT);
        this.netHandler.registerMessage(PacketPersonalChest.class, PacketPersonalChest.PersonalChestMessage.class, 2, Side.SERVER);
        this.netHandler.registerMessage(PacketItemStack.class, PacketItemStack.ItemStackMessage.class, 4, Side.SERVER);
        this.netHandler.registerMessage(PacketTileEntity.class, PacketTileEntity.TileEntityMessage.class, 5, Side.CLIENT);
        this.netHandler.registerMessage(PacketTileEntity.class, PacketTileEntity.TileEntityMessage.class, 5, Side.SERVER);
        this.netHandler.registerMessage(PacketPortalFX.class, PacketPortalFX.PortalFXMessage.class, 6, Side.CLIENT);
        this.netHandler.registerMessage(PacketDataRequest.class, PacketDataRequest.DataRequestMessage.class, 7, Side.SERVER);
        this.netHandler.registerMessage(PacketOredictionificatorGui.class, PacketOredictionificatorGui.OredictionificatorGuiMessage.class, 8, Side.CLIENT);
        this.netHandler.registerMessage(PacketOredictionificatorGui.class, PacketOredictionificatorGui.OredictionificatorGuiMessage.class, 8, Side.SERVER);
        this.netHandler.registerMessage(PacketSecurityMode.class, PacketSecurityMode.SecurityModeMessage.class, 9, Side.SERVER);
        this.netHandler.registerMessage(PacketPortableTeleporter.class, PacketPortableTeleporter.PortableTeleporterMessage.class, 10, Side.CLIENT);
        this.netHandler.registerMessage(PacketPortableTeleporter.class, PacketPortableTeleporter.PortableTeleporterMessage.class, 10, Side.SERVER);
        this.netHandler.registerMessage(PacketRemoveUpgrade.class, PacketRemoveUpgrade.RemoveUpgradeMessage.class, 11, Side.SERVER);
        this.netHandler.registerMessage(PacketRedstoneControl.class, PacketRedstoneControl.RedstoneControlMessage.class, 12, Side.SERVER);
        this.netHandler.registerMessage(PacketLogisticalSorterGui.class, PacketLogisticalSorterGui.LogisticalSorterGuiMessage.class, 14, Side.CLIENT);
        this.netHandler.registerMessage(PacketLogisticalSorterGui.class, PacketLogisticalSorterGui.LogisticalSorterGuiMessage.class, 14, Side.SERVER);
        this.netHandler.registerMessage(PacketNewFilter.class, PacketNewFilter.NewFilterMessage.class, 15, Side.SERVER);
        this.netHandler.registerMessage(PacketEditFilter.class, PacketEditFilter.EditFilterMessage.class, 16, Side.SERVER);
        this.netHandler.registerMessage(PacketConfigurationUpdate.class, PacketConfigurationUpdate.ConfigurationUpdateMessage.class, 17, Side.SERVER);
        this.netHandler.registerMessage(PacketSimpleGui.class, PacketSimpleGui.SimpleGuiMessage.class, 18, Side.CLIENT);
        this.netHandler.registerMessage(PacketSimpleGui.class, PacketSimpleGui.SimpleGuiMessage.class, 18, Side.SERVER);
        this.netHandler.registerMessage(PacketDigitalMinerGui.class, PacketDigitalMinerGui.DigitalMinerGuiMessage.class, 19, Side.CLIENT);
        this.netHandler.registerMessage(PacketDigitalMinerGui.class, PacketDigitalMinerGui.DigitalMinerGuiMessage.class, 19, Side.SERVER);
        this.netHandler.registerMessage(PacketJetpackData.class, PacketJetpackData.JetpackDataMessage.class, 20, Side.CLIENT);
        this.netHandler.registerMessage(PacketJetpackData.class, PacketJetpackData.JetpackDataMessage.class, 20, Side.SERVER);
        this.netHandler.registerMessage(PacketKey.class, PacketKey.KeyMessage.class, 21, Side.SERVER);
        this.netHandler.registerMessage(PacketScubaTankData.class, PacketScubaTankData.ScubaTankDataMessage.class, 22, Side.CLIENT);
        this.netHandler.registerMessage(PacketScubaTankData.class, PacketScubaTankData.ScubaTankDataMessage.class, 22, Side.SERVER);
        this.netHandler.registerMessage(PacketConfigSync.class, PacketConfigSync.ConfigSyncMessage.class, 23, Side.CLIENT);
        this.netHandler.registerMessage(PacketBoxBlacklist.class, PacketBoxBlacklist.BoxBlacklistMessage.class, 24, Side.CLIENT);
        this.netHandler.registerMessage(PacketContainerEditMode.class, PacketContainerEditMode.ContainerEditModeMessage.class, 26, Side.SERVER);
        this.netHandler.registerMessage(PacketFlamethrowerData.class, PacketFlamethrowerData.FlamethrowerDataMessage.class, 27, Side.CLIENT);
        this.netHandler.registerMessage(PacketFlamethrowerData.class, PacketFlamethrowerData.FlamethrowerDataMessage.class, 27, Side.SERVER);
        this.netHandler.registerMessage(PacketDropperUse.class, PacketDropperUse.DropperUseMessage.class, 28, Side.SERVER);
        this.netHandler.registerMessage(PacketEntityMove.class, PacketEntityMove.EntityMoveMessage.class, 29, Side.CLIENT);
        this.netHandler.registerMessage(PacketSecurityUpdate.class, PacketSecurityUpdate.SecurityUpdateMessage.class, 30, Side.CLIENT);
        this.netHandler.registerMessage(PacketFreeRunnerData.class, PacketFreeRunnerData.FreeRunnerDataMessage.class, 31, Side.CLIENT);
        this.netHandler.registerMessage(PacketFreeRunnerData.class, PacketFreeRunnerData.FreeRunnerDataMessage.class, 31, Side.SERVER);
    }

    public static void encode(Object[] dataValues, ByteBuf output) {
        try {
            for (Object data : dataValues) {
                if (data instanceof Byte) {
                    output.writeByte((int)((Byte)data).byteValue());
                    continue;
                }
                if (data instanceof Integer) {
                    output.writeInt(((Integer)data).intValue());
                    continue;
                }
                if (data instanceof Short) {
                    output.writeShort((int)((Short)data).shortValue());
                    continue;
                }
                if (data instanceof Long) {
                    output.writeLong(((Long)data).longValue());
                    continue;
                }
                if (data instanceof Boolean) {
                    output.writeBoolean(((Boolean)data).booleanValue());
                    continue;
                }
                if (data instanceof Double) {
                    output.writeDouble(((Double)data).doubleValue());
                    continue;
                }
                if (data instanceof Float) {
                    output.writeFloat(((Float)data).floatValue());
                    continue;
                }
                if (data instanceof String) {
                    PacketHandler.writeString(output, (String)data);
                    continue;
                }
                if (data instanceof EnumFacing) {
                    output.writeInt(((EnumFacing)data).ordinal());
                    continue;
                }
                if (data instanceof ItemStack) {
                    PacketHandler.writeStack(output, (ItemStack)data);
                    continue;
                }
                if (data instanceof NBTTagCompound) {
                    PacketHandler.writeNBT(output, (NBTTagCompound)data);
                    continue;
                }
                if (data instanceof int[]) {
                    for (int i : (int[])data) {
                        output.writeInt(i);
                    }
                    continue;
                }
                if (data instanceof byte[]) {
                    for (byte b : (byte[])data) {
                        output.writeByte((int)b);
                    }
                    continue;
                }
                if (data instanceof ArrayList) {
                    PacketHandler.encode(((ArrayList)data).toArray(), output);
                    continue;
                }
                if (data instanceof NonNullList) {
                    PacketHandler.encode(((NonNullList)data).toArray(), output);
                    continue;
                }
                throw new RuntimeException("Un-encodable data passed to encode(): " + data + ", full data: " + Arrays.toString(dataValues));
            }
        }
        catch (Exception e) {
            Mekanism.logger.error("Error while encoding packet data.");
            e.printStackTrace();
        }
    }

    public static void writeString(ByteBuf output, String s) {
        ByteBufUtils.writeUTF8String((ByteBuf)output, (String)s);
    }

    public static String readString(ByteBuf input) {
        return ByteBufUtils.readUTF8String((ByteBuf)input);
    }

    public static void writeStack(ByteBuf output, ItemStack stack) {
        ByteBufUtils.writeItemStack((ByteBuf)output, (ItemStack)stack);
    }

    public static ItemStack readStack(ByteBuf input) {
        return ByteBufUtils.readItemStack((ByteBuf)input);
    }

    public static void writeNBT(ByteBuf output, NBTTagCompound nbtTags) {
        ByteBufUtils.writeTag((ByteBuf)output, (NBTTagCompound)nbtTags);
    }

    public static NBTTagCompound readNBT(ByteBuf input) {
        return ByteBufUtils.readTag((ByteBuf)input);
    }

    public static void log(String log) {
        if (MekanismConfig.general.logPackets) {
            Mekanism.logger.info(log);
        }
    }

    public static EntityPlayer getPlayer(MessageContext context) {
        return Mekanism.proxy.getPlayer(context);
    }

    public static void handlePacket(Runnable runnable, EntityPlayer player) {
        Mekanism.proxy.handlePacket(runnable, player);
    }

    public void sendTo(IMessage message, EntityPlayerMP player) {
        this.netHandler.sendTo(message, player);
    }

    public void sendToAll(IMessage message) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        for (EntityPlayerMP player : server.func_184103_al().func_181057_v()) {
            this.sendTo(message, player);
        }
    }

    public void sendToAllAround(IMessage message, NetworkRegistry.TargetPoint point) {
        this.netHandler.sendToAllAround(message, point);
    }

    public void sendToDimension(IMessage message, int dimensionId) {
        this.netHandler.sendToDimension(message, dimensionId);
    }

    public void sendToServer(IMessage message) {
        this.netHandler.sendToServer(message);
    }

    public void sendToCuboid(IMessage message, AxisAlignedBB cuboid, int dimId) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server != null && cuboid != null) {
            for (EntityPlayerMP player : server.func_184103_al().func_181057_v()) {
                if (player.field_71093_bK != dimId || !cuboid.func_72318_a(new Vec3d(player.field_70165_t, player.field_70163_u, player.field_70161_v))) continue;
                this.sendTo(message, player);
            }
        }
    }

    public void sendToReceivers(IMessage message, Range4D range) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server != null) {
            for (EntityPlayerMP player : server.func_184103_al().func_181057_v()) {
                if (player.field_71093_bK != range.dimensionId || !Range4D.getChunkRange((EntityPlayer)player).intersects(range)) continue;
                this.sendTo(message, player);
            }
        }
    }
}

