/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Random;
import mekanism.common.Mekanism;
import mekanism.common.frequency.FrequencyManager;
import mekanism.common.multiblock.MultiblockManager;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class CommonWorldTickHandler {
    private static final long maximumDeltaTimeNanoSecs = 16000000L;
    private HashMap<Integer, Queue<ChunkPos>> chunkRegenMap;

    public void addRegenChunk(int dimensionId, ChunkPos chunkCoord) {
        if (this.chunkRegenMap == null) {
            this.chunkRegenMap = new HashMap();
        }
        if (!this.chunkRegenMap.containsKey(dimensionId)) {
            LinkedList<ChunkPos> list = new LinkedList<ChunkPos>();
            list.add(chunkCoord);
            this.chunkRegenMap.put(dimensionId, list);
        } else if (!this.chunkRegenMap.get(dimensionId).contains(chunkCoord)) {
            this.chunkRegenMap.get(dimensionId).add(chunkCoord);
        }
    }

    public void resetRegenChunks() {
        if (this.chunkRegenMap != null) {
            this.chunkRegenMap.clear();
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.WorldTickEvent event) {
        if (event.side == Side.SERVER) {
            if (event.phase == TickEvent.Phase.START) {
                this.tickStart(event.world);
            } else if (event.phase == TickEvent.Phase.END) {
                this.tickEnd(event.world);
            }
        }
    }

    public void tickStart(World world) {
        if (!world.field_72995_K && !FrequencyManager.loaded) {
            FrequencyManager.load(world);
        }
    }

    public void tickEnd(World world) {
        if (!world.field_72995_K) {
            MultiblockManager.tick(world);
            FrequencyManager.tick(world);
            if (this.chunkRegenMap == null) {
                return;
            }
            int dimensionId = world.field_73011_w.getDimension();
            if (this.chunkRegenMap.containsKey(dimensionId)) {
                ChunkPos nextChunk;
                Queue<ChunkPos> chunksToGen = this.chunkRegenMap.get(dimensionId);
                long startTime = System.nanoTime();
                while (System.nanoTime() - startTime < 16000000L && !chunksToGen.isEmpty() && (nextChunk = chunksToGen.poll()) != null) {
                    Random fmlRandom = new Random(world.func_72905_C());
                    long xSeed = fmlRandom.nextLong() >> 3;
                    long zSeed = fmlRandom.nextLong() >> 3;
                    fmlRandom.setSeed(xSeed * (long)nextChunk.field_77276_a + zSeed * (long)nextChunk.field_77275_b ^ world.func_72905_C());
                    Mekanism.genHandler.generate(fmlRandom, nextChunk.field_77276_a, nextChunk.field_77275_b, world, ((ChunkProviderServer)world.func_72863_F()).field_186029_c, world.func_72863_F());
                    Mekanism.logger.info("[Mekanism] Regenerating ores at chunk " + nextChunk);
                }
                if (chunksToGen.isEmpty()) {
                    this.chunkRegenMap.remove(dimensionId);
                }
            }
        }
    }
}

