/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.transmitters;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.api.IClientTicker;
import mekanism.api.Range4D;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.api.transmitters.INetworkDataHandler;
import mekanism.api.transmitters.TransmitterNetworkRegistry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.commons.lang3.tuple.Pair;

public abstract class DynamicNetwork<A, N extends DynamicNetwork<A, N>>
implements IClientTicker,
INetworkDataHandler {
    public LinkedHashSet<IGridTransmitter<A, N>> transmitters = Sets.newLinkedHashSet();
    public LinkedHashSet<IGridTransmitter<A, N>> transmittersToAdd = Sets.newLinkedHashSet();
    public LinkedHashSet<IGridTransmitter<A, N>> transmittersAdded = Sets.newLinkedHashSet();
    public HashMap<Coord4D, A> possibleAcceptors = new HashMap();
    public HashMap<Coord4D, EnumSet<EnumFacing>> acceptorDirections = new HashMap();
    public HashMap<IGridTransmitter<A, N>, EnumSet<EnumFacing>> changedAcceptors = Maps.newHashMap();
    private Set<DelayQueue> updateQueue = new LinkedHashSet<DelayQueue>();
    protected Range4D packetRange = null;
    protected int capacity = 0;
    protected double meanCapacity = 0.0;
    protected boolean needsUpdate = false;
    protected int updateDelay = 0;
    protected boolean firstUpdate = true;
    protected World world = null;

    public void addNewTransmitters(Collection<IGridTransmitter<A, N>> newTransmitters) {
        this.transmittersToAdd.addAll(newTransmitters);
    }

    public void commit() {
        if (!this.transmittersToAdd.isEmpty()) {
            for (IGridTransmitter iGridTransmitter : this.transmittersToAdd) {
                if (!iGridTransmitter.isValid()) continue;
                if (this.world == null) {
                    this.world = iGridTransmitter.world();
                }
                for (EnumFacing side : EnumFacing.field_82609_l) {
                    this.updateTransmitterOnSide(iGridTransmitter, side);
                }
                iGridTransmitter.setTransmitterNetwork(this);
                this.absorbBuffer(iGridTransmitter);
                this.transmitters.add(iGridTransmitter);
            }
            this.updateCapacity();
            this.clampBuffer();
            this.queueClientUpdate(Lists.newArrayList(this.transmittersToAdd));
            this.transmittersToAdd.clear();
        }
        if (!this.changedAcceptors.isEmpty()) {
            for (Map.Entry entry : this.changedAcceptors.entrySet()) {
                IGridTransmitter transmitter = (IGridTransmitter)entry.getKey();
                if (!transmitter.isValid()) continue;
                EnumSet directionsChanged = (EnumSet)entry.getValue();
                for (EnumFacing side : directionsChanged) {
                    this.updateTransmitterOnSide(transmitter, side);
                }
            }
            this.changedAcceptors.clear();
        }
    }

    public void updateTransmitterOnSide(IGridTransmitter<A, N> transmitter, EnumFacing side) {
        A acceptor = transmitter.getAcceptor(side);
        Coord4D acceptorCoord = transmitter.coord().offset(side);
        EnumSet<EnumFacing> directions = this.acceptorDirections.get(acceptorCoord);
        if (acceptor != null) {
            this.possibleAcceptors.put(acceptorCoord, acceptor);
            if (directions != null) {
                directions.add(side.func_176734_d());
            } else {
                this.acceptorDirections.put(acceptorCoord, EnumSet.of(side.func_176734_d()));
            }
        } else if (directions != null) {
            directions.remove(side.func_176734_d());
            if (directions.isEmpty()) {
                this.possibleAcceptors.remove(acceptorCoord);
                this.acceptorDirections.remove(acceptorCoord);
            }
        } else {
            this.possibleAcceptors.remove(acceptorCoord);
            this.acceptorDirections.remove(acceptorCoord);
        }
    }

    public abstract void absorbBuffer(IGridTransmitter<A, N> var1);

    public abstract void clampBuffer();

    public void invalidate() {
        this.transmitters.removeIf(transmitter -> !transmitter.isValid());
        this.clampBuffer();
        for (IGridTransmitter iGridTransmitter : this.transmitters) {
            iGridTransmitter.updateShare();
        }
        for (IGridTransmitter iGridTransmitter : this.transmitters) {
            this.invalidateTransmitter(iGridTransmitter);
        }
        this.transmitters.clear();
        this.deregister();
    }

    public void invalidateTransmitter(IGridTransmitter<A, N> transmitter) {
        if (!this.world.field_72995_K && transmitter.isValid()) {
            transmitter.takeShare();
            transmitter.setTransmitterNetwork(null);
            TransmitterNetworkRegistry.registerOrphanTransmitter(transmitter);
        }
    }

    public void acceptorChanged(IGridTransmitter<A, N> transmitter, EnumFacing side) {
        EnumSet<EnumFacing> directions = this.changedAcceptors.get(transmitter);
        if (directions != null) {
            directions.add(side);
        } else {
            this.changedAcceptors.put(transmitter, EnumSet.of(side));
        }
        TransmitterNetworkRegistry.registerChangedNetwork(this);
    }

    public void adoptTransmittersAndAcceptorsFrom(N net) {
        for (IGridTransmitter iGridTransmitter : ((DynamicNetwork)net).transmitters) {
            iGridTransmitter.setTransmitterNetwork(this);
            this.transmitters.add(iGridTransmitter);
            this.transmittersAdded.add(iGridTransmitter);
        }
        this.transmittersToAdd.addAll(((DynamicNetwork)net).transmittersToAdd);
        this.possibleAcceptors.putAll(((DynamicNetwork)net).possibleAcceptors);
        for (Map.Entry entry : ((DynamicNetwork)net).acceptorDirections.entrySet()) {
            Coord4D coord = (Coord4D)entry.getKey();
            if (this.acceptorDirections.containsKey(coord)) {
                this.acceptorDirections.get(coord).addAll((Collection)entry.getValue());
                continue;
            }
            this.acceptorDirections.put(coord, (EnumSet<EnumFacing>)entry.getValue());
        }
    }

    public Range4D getPacketRange() {
        if (this.packetRange == null) {
            return this.genPacketRange();
        }
        return this.packetRange;
    }

    protected Range4D genPacketRange() {
        if (this.getSize() == 0) {
            this.deregister();
            return null;
        }
        IGridTransmitter initTransmitter = (IGridTransmitter)this.transmitters.iterator().next();
        Coord4D initCoord = initTransmitter.coord();
        int minX = initCoord.x;
        int minY = initCoord.y;
        int minZ = initCoord.z;
        int maxX = initCoord.x;
        int maxY = initCoord.y;
        int maxZ = initCoord.z;
        for (IGridTransmitter iGridTransmitter : this.transmitters) {
            Coord4D coord = iGridTransmitter.coord();
            if (coord.x < minX) {
                minX = coord.x;
            }
            if (coord.y < minY) {
                minY = coord.y;
            }
            if (coord.z < minZ) {
                minZ = coord.z;
            }
            if (coord.x > maxX) {
                maxX = coord.x;
            }
            if (coord.y > maxY) {
                maxY = coord.y;
            }
            if (coord.x <= maxZ) continue;
            maxZ = coord.z;
        }
        return new Range4D(minX, minY, minZ, maxX, maxY, maxZ, initTransmitter.world().field_73011_w.getDimension());
    }

    public void register() {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            TransmitterNetworkRegistry.getInstance().registerNetwork(this);
        } else {
            MinecraftForge.EVENT_BUS.post((Event)new ClientTickUpdate(this, 1));
        }
    }

    public void deregister() {
        this.transmitters.clear();
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            TransmitterNetworkRegistry.getInstance().removeNetwork(this);
        } else {
            MinecraftForge.EVENT_BUS.post((Event)new ClientTickUpdate(this, 0));
        }
    }

    public int getSize() {
        return this.transmitters.size();
    }

    public int getAcceptorSize() {
        return this.possibleAcceptors.size();
    }

    public synchronized void updateCapacity() {
        this.updateMeanCapacity();
        this.capacity = (int)this.meanCapacity * this.transmitters.size();
    }

    protected synchronized void updateMeanCapacity() {
        this.meanCapacity = this.transmitters.size() > 0 ? (double)((IGridTransmitter)this.transmitters.iterator().next()).getCapacity() : 0.0;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public World getWorld() {
        return this.world;
    }

    public abstract Set<Pair<Coord4D, A>> getAcceptors(Object var1);

    public void tick() {
        this.onUpdate();
    }

    public void onUpdate() {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            Iterator<DelayQueue> i = this.updateQueue.iterator();
            try {
                while (i.hasNext()) {
                    DelayQueue q = i.next();
                    if (q.delay > 0) {
                        --q.delay;
                        continue;
                    }
                    this.transmittersAdded.addAll(this.transmitters);
                    this.updateDelay = 1;
                    i.remove();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0) {
                    MinecraftForge.EVENT_BUS.post((Event)new TransmittersAddedEvent(this, this.firstUpdate, this.transmittersAdded));
                    this.firstUpdate = false;
                    this.transmittersAdded.clear();
                    this.needsUpdate = true;
                }
            }
        }
    }

    @Override
    public boolean needsTicks() {
        return this.getSize() > 0;
    }

    @Override
    public void clientTick() {
    }

    public void queueClientUpdate(Collection<IGridTransmitter<A, N>> newTransmitters) {
        this.transmittersAdded.addAll(newTransmitters);
        this.updateDelay = 5;
    }

    public void addUpdate(EntityPlayer player) {
        this.updateQueue.add(new DelayQueue(player));
    }

    public static class DelayQueue {
        public EntityPlayer player;
        public int delay;

        public DelayQueue(EntityPlayer p) {
            this.player = p;
            this.delay = 5;
        }

        public int hashCode() {
            return this.player.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof DelayQueue && ((DelayQueue)o).player.equals((Object)this.player);
        }
    }

    public static class NetworkClientRequest
    extends Event {
        public TileEntity tileEntity;

        public NetworkClientRequest(TileEntity tile) {
            this.tileEntity = tile;
        }
    }

    public static class ClientTickUpdate
    extends Event {
        public DynamicNetwork network;
        public byte operation;

        public ClientTickUpdate(DynamicNetwork net, byte b) {
            this.network = net;
            this.operation = b;
        }
    }

    public static class TransmittersAddedEvent
    extends Event {
        public DynamicNetwork<?, ?> network;
        public boolean newNetwork;
        public Collection<IGridTransmitter> newTransmitters;

        public TransmittersAddedEvent(DynamicNetwork net, boolean newNet, Collection<IGridTransmitter> added) {
            this.network = net;
            this.newNetwork = newNet;
            this.newTransmitters = added;
        }
    }
}

