/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api;

import java.util.HashSet;
import java.util.Set;
import mekanism.api.MekanismRecipeHelper;
import mekanism.api.util.BlockInfo;
import net.minecraft.block.Block;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.logging.log4j.LogManager;

public class MekanismAPI {
    private static Set<BlockInfo> cardboardBoxIgnore = new HashSet<BlockInfo>();
    private static MekanismRecipeHelper helper = null;
    public static boolean debug = false;

    public static boolean isBlockCompatible(Block block, int meta) {
        for (BlockInfo i : cardboardBoxIgnore) {
            if (i.block != block || i.meta != Short.MAX_VALUE && i.meta != meta) continue;
            return false;
        }
        return true;
    }

    public static void addBoxBlacklist(Block block, int meta) {
        cardboardBoxIgnore.add(new BlockInfo(block, meta));
    }

    public static void removeBoxBlacklist(Block block, int meta) {
        cardboardBoxIgnore.remove(new BlockInfo(block, meta));
    }

    public static Set<BlockInfo> getBoxIgnore() {
        return cardboardBoxIgnore;
    }

    public static MekanismRecipeHelper recipeHelper() {
        if (helper == null) {
            try {
                helper = (MekanismRecipeHelper)Class.forName("mekanism.common.recipe.APIHandler").newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                LogManager.getLogger((String)"MekanismAPI").error("Could not find API Handler", (Throwable)e);
            }
        }
        return helper;
    }

    public static class BoxBlacklistEvent
    extends Event {
    }
}

