/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.util;

import ic2.api.item.IC2Items;
import java.util.HashMap;
import javax.annotation.Nonnull;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.recipe.INasaWorkbenchRecipe;
import micdoodle8.mods.galacticraft.core.inventory.InventoryBuggyBench;
import micdoodle8.mods.galacticraft.core.inventory.InventoryRocketBench;
import micdoodle8.mods.galacticraft.core.recipe.NasaWorkbenchRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RecipeUtil {
    @Nonnull
    public static ItemStack findMatchingBuggy(InventoryBuggyBench benchStacks) {
        for (INasaWorkbenchRecipe recipe : GalacticraftRegistry.getBuggyBenchRecipes()) {
            if (!recipe.matches(benchStacks)) continue;
            return recipe.getRecipeOutput();
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public static ItemStack findMatchingSpaceshipRecipe(InventoryRocketBench inventoryRocketBench) {
        for (INasaWorkbenchRecipe recipe : GalacticraftRegistry.getRocketT1Recipes()) {
            if (!recipe.matches(inventoryRocketBench)) continue;
            return recipe.getRecipeOutput();
        }
        return ItemStack.field_190927_a;
    }

    public static void addRecipe(ItemStack result, Object[] obj) {
        CraftingHelper.ShapedPrimer pattern = CraftingHelper.parseShaped((Object[])obj);
        RecipeUtil.addCustomRecipe((IRecipe)new ShapedRecipes(result.func_77973_b().getRegistryName().toString(), pattern.width, pattern.height, pattern.input, result));
    }

    public static void addCustomRecipe(IRecipe rec) {
        String modID = Loader.instance().activeModContainer().getModId();
        ResourceLocation newLocation = new ResourceLocation(modID, rec.func_77571_b().func_77973_b().getRegistryName().func_110623_a());
        if (CraftingManager.field_193380_a.func_148741_d((Object)newLocation)) {
            int count = 1;
            String newNameBase = newLocation.func_110623_a() + "_";
            while (CraftingManager.field_193380_a.func_148741_d((Object)newLocation)) {
                newLocation = new ResourceLocation(modID, newNameBase + count++);
            }
        }
        rec.setRegistryName(newLocation);
        GameData.register_impl((IForgeRegistryEntry)rec);
    }

    public static void addRocketBenchRecipe(ItemStack result, HashMap<Integer, ItemStack> input) {
        GalacticraftRegistry.addT1RocketRecipe(new NasaWorkbenchRecipe(result, input));
    }

    public static void addBuggyBenchRecipe(ItemStack result, HashMap<Integer, ItemStack> input) {
        GalacticraftRegistry.addMoonBuggyRecipe(new NasaWorkbenchRecipe(result, input));
    }

    public static ItemStack getIndustrialCraftItem(String indentifier, String variant) {
        return IC2Items.getItem((String)indentifier, (String)variant);
    }
}

