/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import java.util.EnumSet;
import micdoodle8.mods.galacticraft.api.world.EnumAtmosphericGas;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GCFluids;
import micdoodle8.mods.galacticraft.core.blocks.BlockOxygenCollector;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.inventory.IInventoryDefaults;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygen;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.BlockAir;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntityOxygenCollector
extends TileEntityOxygen
implements IInventoryDefaults,
ISidedInventory {
    public boolean active;
    public static final int OUTPUT_PER_TICK = 100;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public float lastOxygenCollected;
    private NonNullList<ItemStack> stacks = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    private boolean noAtmosphericOxygen = true;
    private boolean isInitialised = false;
    private boolean producedLastTick = false;

    public TileEntityOxygenCollector() {
        super(6000, 0);
        this.noRedstoneControl = true;
    }

    @Override
    public int getCappedScaledOxygenLevel(int scale) {
        return (int)Math.max(Math.min(Math.floor((double)this.getOxygenStored() / (double)this.getMaxOxygenStored() * (double)scale), (double)scale), 0.0);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            this.producedLastTick = this.getOxygenStored() < this.getMaxOxygenStored();
            this.produceOxygen();
            if (this.field_145850_b.field_73012_v.nextInt(10) == 0) {
                if (this.hasEnoughEnergyToRun) {
                    float nearbyLeaves = 0.0f;
                    if (!this.isInitialised) {
                        this.noAtmosphericOxygen = this.field_145850_b.field_73011_w instanceof IGalacticraftWorldProvider && !((IGalacticraftWorldProvider)this.field_145850_b.field_73011_w).isGasPresent(EnumAtmosphericGas.OXYGEN);
                        this.isInitialised = true;
                    }
                    if (this.noAtmosphericOxygen) {
                        if (this.func_174877_v().func_177958_n() > -29999995 && this.func_174877_v().func_177956_o() < 2999995 && this.func_174877_v().func_177952_p() > -29999995 && this.func_174877_v().func_177952_p() < 29999995) {
                            int miny = this.func_174877_v().func_177956_o() - 5;
                            int maxy = this.func_174877_v().func_177956_o() + 5;
                            if (miny < 0) {
                                miny = 0;
                            }
                            if (maxy >= this.field_145850_b.func_72800_K()) {
                                maxy = this.field_145850_b.func_72800_K() - 1;
                            }
                            for (int x = this.func_174877_v().func_177958_n() - 5; x <= this.func_174877_v().func_177958_n() + 5; ++x) {
                                int chunkx = x >> 4;
                                int intrachunkx = x & 0xF;
                                int chunkz = this.func_174877_v().func_177952_p() - 5 >> 4;
                                Chunk chunk = this.field_145850_b.func_72964_e(chunkx, chunkz);
                                for (int z = this.func_174877_v().func_177952_p() - 5; z <= this.func_174877_v().func_177952_p() + 5; ++z) {
                                    if (z >> 4 != chunkz) {
                                        chunkz = z >> 4;
                                        chunk = this.field_145850_b.func_72964_e(chunkx, chunkz);
                                    }
                                    for (int y = miny; y <= maxy; ++y) {
                                        IBlockState state = chunk.func_186032_a(intrachunkx, y, z & 0xF);
                                        if (state.func_177230_c() instanceof BlockAir) continue;
                                        BlockPos pos = new BlockPos(x, y, z);
                                        if (!state.func_177230_c().isLeaves(state, (IBlockAccess)this.field_145850_b, pos) && (!(state.func_177230_c() instanceof IPlantable) || ((IPlantable)state.func_177230_c()).getPlantType((IBlockAccess)this.field_145850_b, pos) != EnumPlantType.Crop)) continue;
                                        nearbyLeaves += 0.75f;
                                    }
                                }
                            }
                        }
                    } else {
                        nearbyLeaves = 93.0f;
                    }
                    nearbyLeaves = (float)Math.floor(nearbyLeaves);
                    this.lastOxygenCollected = nearbyLeaves / 10.0f;
                    this.tank.setFluid(new FluidStack(GCFluids.fluidOxygenGas, (int)Math.max(Math.min((float)this.getOxygenStored() + nearbyLeaves, (float)this.getMaxOxygenStored()), 0.0f)));
                } else {
                    this.lastOxygenCollected = 0.0f;
                }
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.stacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)nbt, this.stacks);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        ItemStackHelper.func_191282_a((NBTTagCompound)nbt, this.stacks);
        return nbt;
    }

    public int func_70302_i_() {
        return this.stacks.size();
    }

    public ItemStack func_70301_a(int var1) {
        return (ItemStack)this.stacks.get(var1);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.stacks, (int)index, (int)count);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack oldstack = ItemStackHelper.func_188383_a(this.stacks, (int)index);
        if (!oldstack.func_190926_b()) {
            this.func_70296_d();
        }
        return oldstack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.stacks.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.stacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public String func_70005_c_() {
        return GCCoreUtil.translate("container.oxygencollector.name");
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this && par1EntityPlayer.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    @Override
    public boolean func_145818_k_() {
        return true;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0};
    }

    public boolean func_180462_a(int slotID, ItemStack itemstack, EnumFacing side) {
        return this.func_94041_b(slotID, itemstack);
    }

    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        return slotID == 0;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        return slotID == 0 && ItemElectricBase.isElectricItem(itemstack.func_77973_b());
    }

    @Override
    public boolean shouldUseEnergy() {
        return (float)this.getOxygenStored() > 0.0f && this.producedLastTick;
    }

    @Override
    public EnumFacing getFront() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockOxygenCollector) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockOxygenCollector.FACING);
        }
        return EnumFacing.NORTH;
    }

    @Override
    public EnumFacing getElectricInputDirection() {
        return this.getFront().func_176746_e();
    }

    @Override
    public ItemStack getBatteryInSlot() {
        return this.func_70301_a(0);
    }

    @Override
    public boolean shouldPullOxygen() {
        return false;
    }

    @Override
    public boolean shouldUseOxygen() {
        return false;
    }

    @Override
    public EnumSet<EnumFacing> getOxygenInputDirections() {
        return EnumSet.noneOf(EnumFacing.class);
    }

    @Override
    public EnumSet<EnumFacing> getOxygenOutputDirections() {
        return EnumSet.of(this.getElectricInputDirection().func_176734_d());
    }

    @Override
    public int getOxygenProvide(EnumFacing direction) {
        return this.getOxygenOutputDirections().contains(direction) ? Math.min(500, this.getOxygenStored()) : 0;
    }
}

