/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.entities;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import micdoodle8.mods.galacticraft.core.GCFluids;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.entities.EntityAdvancedMotion;
import micdoodle8.mods.galacticraft.core.entities.IScaleableFuelLevel;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.inventory.IInventorySettable;
import micdoodle8.mods.galacticraft.core.network.PacketDynamic;
import micdoodle8.mods.galacticraft.core.network.PacketDynamicInventory;
import micdoodle8.mods.galacticraft.core.util.FluidUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityLanderBase
extends EntityAdvancedMotion
implements IInventorySettable,
IScaleableFuelLevel {
    private final int FUEL_TANK_CAPACITY = 5000;
    public FluidTank fuelTank = new FluidTank(this.FUEL_TANK_CAPACITY);
    protected boolean hasReceivedPacket;
    private boolean lastShouldMove;
    private UUID persistantRiderUUID;
    private Boolean shouldMoveClient;
    private Boolean shouldMoveServer;
    private ArrayList prevData;
    private boolean networkDataChanged;
    private boolean syncAdjustFlag = true;

    public EntityLanderBase(World var1) {
        super(var1);
        this.func_70105_a(3.0f, 3.0f);
    }

    @Override
    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            passenger.func_70107_b(this.field_70165_t, this.field_70163_u + this.func_70042_X() + passenger.func_70033_W(), this.field_70161_v);
        }
    }

    @Override
    public boolean shouldSendAdvancedMotionPacket() {
        return this.shouldMoveClient != null && this.shouldMoveServer != null;
    }

    @Override
    public boolean canSetPositionClient() {
        return this.shouldSendAdvancedMotionPacket();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean b) {
        super.func_180426_a(x, y, z, yaw, pitch, posRotationIncrements, b);
        if (this.syncAdjustFlag && this.field_70170_p.func_175667_e(new BlockPos(x, 255.0, z))) {
            EntityPlayerSP p = FMLClientHandler.instance().getClientPlayerEntity();
            double dx = x - p.field_70165_t;
            double dz = z - p.field_70161_v;
            if (dx * dx + dz * dz < 1024.0) {
                if (!this.field_70170_p.field_72996_f.contains(this)) {
                    try {
                        this.field_70170_p.field_72996_f.add(this);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.field_70165_t = x;
                this.field_70163_u = y;
                this.field_70161_v = z;
                int cx = MathHelper.func_76128_c((double)(x / 16.0));
                int cz = MathHelper.func_76128_c((double)(z / 16.0));
                if (!this.field_70175_ag || this.field_70176_ah != cx || this.field_70164_aj != cz) {
                    if (this.field_70175_ag && this.field_70170_p.func_175668_a(new BlockPos(this.field_70176_ah << 4, 255, this.field_70164_aj << 4), true)) {
                        this.field_70170_p.func_72964_e(this.field_70176_ah, this.field_70164_aj).func_76608_a((Entity)this, this.field_70162_ai);
                    }
                    this.field_70175_ag = true;
                    this.field_70170_p.func_72964_e(cx, cz).func_76612_a((Entity)this);
                }
                this.syncAdjustFlag = false;
            }
        }
    }

    @Override
    public int getScaledFuelLevel(int i) {
        double fuelLevel = this.fuelTank.getFluid() == null ? 0.0 : (double)this.fuelTank.getFluid().amount;
        return (int)(fuelLevel * (double)i / (double)this.FUEL_TANK_CAPACITY);
    }

    public EntityLanderBase(World var1, double var2, double var4, double var6, float yOffset) {
        this(var1);
        this.func_70107_b(var2, var4, var6);
    }

    public EntityLanderBase(EntityPlayerMP player, float yOffset) {
        this(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, yOffset);
        GCPlayerStats stats = GCPlayerStats.get((Entity)player);
        this.stacks = NonNullList.func_191197_a((int)(stats.getRocketStacks().size() + 1), (Object)ItemStack.field_190927_a);
        this.fuelTank.setFluid(new FluidStack(GCFluids.fluidFuel, stats.getFuelLevel()));
        for (int i = 0; i < stats.getRocketStacks().size(); ++i) {
            if (!((ItemStack)stats.getRocketStacks().get(i)).func_190926_b()) {
                this.stacks.set(i, (Object)((ItemStack)stats.getRocketStacks().get(i)).func_77946_l());
                continue;
            }
            ((ItemStack)this.stacks.get(i)).func_190920_e(0);
        }
        this.func_70080_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.0f, 0.0f);
        player.func_184205_a((Entity)this, true);
    }

    @Override
    public void func_70071_h_() {
        AxisAlignedBB box;
        List var15;
        EntityPlayer player;
        super.func_70071_h_();
        if (this.ticks < 40L && this.field_70163_u > 150.0 && this.func_184188_bt().isEmpty() && (player = this.field_70170_p.func_72890_a((Entity)this, 5.0)) != null && player.func_184187_bx() == null) {
            player.func_184220_m((Entity)this);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.checkFluidTankTransfer(this.stacks.size() - 1, this.fuelTank);
        }
        if ((var15 = this.field_70170_p.func_72839_b((Entity)this, box = this.func_174813_aQ().func_72321_a(0.2, 0.4, 0.2))) != null && !var15.isEmpty()) {
            for (Entity entity : var15) {
                if (this.func_184188_bt().contains(entity)) continue;
                this.pushEntityAway(entity);
            }
        }
    }

    private void checkFluidTankTransfer(int slot, FluidTank tank) {
        FluidUtil.tryFillContainerFuel(tank, (NonNullList<ItemStack>)this.stacks, slot);
    }

    private void pushEntityAway(Entity entityToPush) {
        double d1;
        double d0;
        double d2;
        if (!this.func_184188_bt().contains(entityToPush) && this.func_184187_bx() != entityToPush && (d2 = MathHelper.func_76132_a((double)(d0 = this.field_70165_t - entityToPush.field_70165_t), (double)(d1 = this.field_70161_v - entityToPush.field_70161_v))) >= (double)0.01f) {
            d2 = MathHelper.func_76133_a((double)d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.05f;
            d1 *= (double)0.05f;
            entityToPush.func_70024_g(-(d0 *= (double)(1.0f - entityToPush.field_70144_Y)), 0.0, -(d1 *= (double)(1.0f - entityToPush.field_70144_Y)));
        }
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        int invSize = nbt.func_74762_e("rocketStacksLength");
        if (invSize < 3) {
            invSize = 3;
        }
        this.stacks = NonNullList.func_191197_a((int)invSize, (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)nbt, (NonNullList)this.stacks);
        if (nbt.func_74764_b("fuelTank")) {
            this.fuelTank.readFromNBT(nbt.func_74775_l("fuelTank"));
        }
        if (nbt.func_74764_b("RiderUUID_LSB")) {
            this.persistantRiderUUID = new UUID(nbt.func_74763_f("RiderUUID_LSB"), nbt.func_74763_f("RiderUUID_MSB"));
        }
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbt) {
        UUID id;
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        nbt.func_74768_a("rocketStacksLength", this.stacks.size());
        ItemStackHelper.func_191282_a((NBTTagCompound)nbt, (NonNullList)this.stacks);
        if (this.fuelTank.getFluid() != null) {
            nbt.func_74782_a("fuelTank", (NBTBase)this.fuelTank.writeToNBT(new NBTTagCompound()));
        }
        if ((id = this.getOwnerUUID()) != null) {
            nbt.func_74772_a("RiderUUID_LSB", id.getLeastSignificantBits());
            nbt.func_74772_a("RiderUUID_MSB", id.getMostSignificantBits());
        }
    }

    @Override
    public boolean shouldMove() {
        if (this.shouldMoveClient == null || this.shouldMoveServer == null) {
            return false;
        }
        if (this.ticks < 40L) {
            return false;
        }
        return !this.field_70122_E;
    }

    public abstract double getInitialMotionY();

    @Override
    public void tickInAir() {
        if (this.field_70170_p.field_72995_K) {
            if (!this.shouldMove()) {
                this.field_70179_y = 0.0;
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
            }
            if (this.shouldMove() && !this.lastShouldMove) {
                this.field_70181_x = this.getInitialMotionY();
            }
            this.lastShouldMove = this.shouldMove();
        }
    }

    @Override
    public ArrayList<Object> getNetworkedData() {
        ArrayList<Object> objList = new ArrayList<Object>();
        if (!this.field_70170_p.field_72995_K) {
            Integer cargoLength = this.stacks != null ? this.stacks.size() : 0;
            objList.add(cargoLength);
            objList.add(this.fuelTank.getFluid() == null ? 0 : this.fuelTank.getFluid().amount);
        }
        if (this.field_70170_p.field_72995_K) {
            this.shouldMoveClient = this.shouldMove();
            objList.add(this.shouldMoveClient);
        } else {
            this.shouldMoveServer = this.shouldMove();
            objList.add(this.shouldMoveServer);
            objList.add(this.func_184188_bt().isEmpty() ? -1 : ((Entity)this.func_184188_bt().get(0)).func_145782_y());
        }
        this.networkDataChanged = !objList.equals(this.prevData);
        this.prevData = objList;
        return objList;
    }

    @Override
    public boolean networkedDataChanged() {
        return this.networkDataChanged || this.shouldMoveClient == null || this.shouldMoveServer == null;
    }

    public boolean canRiderInteract() {
        return true;
    }

    @Override
    public int getPacketTickSpacing() {
        return 2;
    }

    @Override
    public double getPacketSendDistance() {
        return 250.0;
    }

    @Override
    public void readNetworkedData(ByteBuf buffer) {
        try {
            if (this.field_70170_p.field_72995_K) {
                if (!this.hasReceivedPacket) {
                    GalacticraftCore.packetPipeline.sendToServer(new PacketDynamic(this));
                    this.hasReceivedPacket = true;
                }
                int cargoLength = buffer.readInt();
                if (this.stacks == null || this.stacks.isEmpty()) {
                    this.stacks = NonNullList.func_191197_a((int)cargoLength, (Object)ItemStack.field_190927_a);
                    GalacticraftCore.packetPipeline.sendToServer(new PacketDynamicInventory(this));
                }
                this.fuelTank.setFluid(new FluidStack(GCFluids.fluidFuel, buffer.readInt()));
                this.shouldMoveServer = buffer.readBoolean();
                int shouldBeMountedId = buffer.readInt();
                if (this.func_184188_bt().isEmpty()) {
                    Entity e;
                    if (shouldBeMountedId > -1 && (e = FMLClientHandler.instance().getWorldClient().func_73045_a(shouldBeMountedId)) != null) {
                        if (e.field_71093_bK != this.field_71093_bK) {
                            if (e instanceof EntityPlayer) {
                                e = WorldUtil.forceRespawnClient(this.field_71093_bK, e.field_70170_p.func_175659_aa().func_151525_a(), e.field_70170_p.func_72912_H().func_76067_t().func_77127_a(), ((EntityPlayerMP)e).field_71134_c.func_73081_b().func_77148_a());
                                e.func_184220_m((Entity)this);
                                this.syncAdjustFlag = true;
                            }
                        } else {
                            e.func_184220_m((Entity)this);
                            this.syncAdjustFlag = true;
                        }
                    }
                } else if (((Entity)this.func_184188_bt().get(0)).func_145782_y() != shouldBeMountedId) {
                    if (shouldBeMountedId == -1) {
                        this.func_184226_ay();
                    } else {
                        Entity e = FMLClientHandler.instance().getWorldClient().func_73045_a(shouldBeMountedId);
                        if (e != null) {
                            if (e.field_71093_bK != this.field_71093_bK) {
                                if (e instanceof EntityPlayer) {
                                    e = WorldUtil.forceRespawnClient(this.field_71093_bK, e.field_70170_p.func_175659_aa().func_151525_a(), e.field_70170_p.func_72912_H().func_76067_t().func_77127_a(), ((EntityPlayerMP)e).field_71134_c.func_73081_b().func_77148_a());
                                    e.func_184205_a((Entity)this, true);
                                    this.syncAdjustFlag = true;
                                }
                            } else {
                                e.func_184205_a((Entity)this, true);
                                this.syncAdjustFlag = true;
                            }
                        }
                    }
                }
            } else {
                this.shouldMoveClient = buffer.readBoolean();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean allowDamageSource(DamageSource damageSource) {
        return !damageSource.func_94541_c();
    }

    @Override
    public List<ItemStack> getItemsDropped() {
        return this.stacks;
    }

    public int func_70302_i_() {
        return this.stacks.size();
    }

    @Override
    public void setSizeInventory(int size) {
        this.stacks = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
    }

    public boolean func_94041_b(int var1, ItemStack var2) {
        return false;
    }

    @Override
    public double getPacketRange() {
        return 50.0;
    }

    @Override
    public UUID getOwnerUUID() {
        UUID id;
        if (!this.func_184188_bt().isEmpty() && !(this.func_184188_bt().get(0) instanceof EntityPlayer)) {
            return null;
        }
        if (!this.func_184188_bt().isEmpty()) {
            this.persistantRiderUUID = id = ((Entity)this.func_184188_bt().get(0)).getPersistentID();
        } else {
            id = this.persistantRiderUUID;
        }
        return id;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        BlockPos blockpos;
        double height = this.field_70163_u + (double)this.func_70047_e();
        if (height > 255.0) {
            height = 255.0;
        }
        return this.field_70170_p.func_175667_e(blockpos = new BlockPos(this.field_70165_t, height, this.field_70161_v)) ? this.field_70170_p.func_175626_b(blockpos, 0) : 0;
    }
}

