/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.entities;

import java.util.UUID;
import micdoodle8.mods.galacticraft.api.entity.IEntityBreathable;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAICreeperSwell;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class EntityEvolvedCreeper
extends EntityCreeper
implements IEntityBreathable {
    private float sizeXBase = -1.0f;
    private float sizeYBase;
    private static final DataParameter<Boolean> IS_CHILD = EntityDataManager.func_187226_a(EntityEvolvedCreeper.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final UUID babySpeedBoostUUID = UUID.fromString("ef67a435-32a4-4efd-b218-e7431438b109");
    private static final AttributeModifier babySpeedBoostModifier = new AttributeModifier(babySpeedBoostUUID, "Baby speed boost evolved creeper", 0.5, 1);

    public EntityEvolvedCreeper(World par1World) {
        super(par1World);
        this.field_70714_bg.field_75782_a.clear();
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAICreeperSwell((EntityCreeper)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityOcelot.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.func_70105_a(0.7f, 2.2f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_CHILD, (Object)false);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(25.0);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (this.func_70631_g_()) {
            nbt.func_74757_a("IsBaby", true);
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74767_n("IsBaby")) {
            this.setChild(true);
        }
    }

    @Override
    public boolean canBreath() {
        return true;
    }

    public void setChildSize(boolean isChild) {
        this.setCreeperScale(isChild ? 0.5f : 1.0f);
    }

    protected final void func_70105_a(float sizeX, float sizeY) {
        boolean flag = this.sizeXBase > 0.0f && this.sizeYBase > 0.0f;
        this.sizeXBase = sizeX;
        this.sizeYBase = sizeY;
        if (!flag) {
            this.setCreeperScale(1.0f);
        }
    }

    protected final void setCreeperScale(float scale) {
        super.func_70105_a(this.sizeXBase * scale, this.sizeYBase * scale);
    }

    public boolean func_70631_g_() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_CHILD);
    }

    protected int func_70693_a(EntityPlayer p_70693_1_) {
        if (this.func_70631_g_()) {
            this.field_70728_aV = this.field_70728_aV * 5 / 2;
        }
        return super.func_70693_a(p_70693_1_);
    }

    public void setChild(boolean isChild) {
        this.field_70180_af.func_187227_b(IS_CHILD, (Object)isChild);
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            IAttributeInstance iattributeinstance = this.func_110148_a(SharedMonsterAttributes.field_111263_d);
            iattributeinstance.func_111124_b(babySpeedBoostModifier);
            if (isChild) {
                iattributeinstance.func_111121_a(babySpeedBoostModifier);
            }
        }
        this.setChildSize(isChild);
    }

    protected void func_70664_aZ() {
        this.field_70181_x = 0.45 / (double)WorldUtil.getGravityFactor((Entity)this);
        if (this.field_70181_x < 0.22) {
            this.field_70181_x = 0.22;
        }
        if (this.func_70644_a(MobEffects.field_76430_j)) {
            this.field_70181_x += (double)((float)(this.func_70660_b(MobEffects.field_76430_j).func_76458_c() + 1) * 0.1f);
        }
        if (this.func_70051_ag()) {
            float f = this.field_70177_z / 57.295776f;
            this.field_70159_w -= (double)(MathHelper.func_76126_a((float)f) * 0.2f);
            this.field_70179_y += (double)(MathHelper.func_76134_b((float)f) * 0.2f);
        }
        this.field_70160_al = true;
        ForgeHooks.onLivingJump((EntityLivingBase)this);
    }

    protected void addRandomDrop() {
        switch (this.field_70146_Z.nextInt(12)) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.func_70099_a(new ItemStack((Block)Blocks.field_150354_m), 0.0f);
                break;
            }
            case 4: 
            case 5: {
                this.func_70099_a(new ItemStack(GCItems.oxTankMedium, 1, 901 + this.field_70146_Z.nextInt(900)), 0.0f);
                break;
            }
            case 6: {
                this.func_145779_a(GCItems.oxygenGear, 1);
                break;
            }
            case 7: 
            case 8: {
                this.func_70099_a(new ItemStack(Blocks.field_150432_aD), 0.0f);
                break;
            }
            default: {
                if (!ConfigManagerCore.challengeMobDropsAndSpawning) break;
                this.func_145779_a(Items.field_151120_aE, 1);
            }
        }
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        super.func_70628_a(wasRecentlyHit, lootingModifier);
        if (this.field_70718_bc > 0 && this.field_70146_Z.nextFloat() < 0.025f + (float)lootingModifier * 0.01f) {
            this.addRandomDrop();
        }
    }
}

