/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import micdoodle8.mods.galacticraft.api.block.IPartialSealableBlock;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockMulti;
import micdoodle8.mods.galacticraft.core.blocks.BlockTileGC;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.items.IShiftDescription;
import micdoodle8.mods.galacticraft.core.tile.TileEntityDish;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockDish
extends BlockTileGC
implements IShiftDescription,
IPartialSealableBlock,
ISortableBlock {
    public BlockDish(String assetName) {
        super(Material.field_151573_f);
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149663_c(assetName);
    }

    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        for (int y = 1; y <= 2; ++y) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos pos1 = pos.func_177982_a(y == 2 ? x : 0, y, y == 2 ? z : 0);
                    Block block = world.func_180495_p(pos1).func_177230_c();
                    if (block.func_149688_o(world.func_180495_p(pos)) == Material.field_151579_a || block.func_176200_f((IBlockAccess)world, pos1)) continue;
                    return false;
                }
            }
        }
        EnumFacing facing = EnumFacing.func_82600_a((int)(side.func_176745_a() ^ 1));
        return world.func_180495_p(pos.func_177982_a(facing.func_82601_c(), facing.func_96559_d(), facing.func_82599_e())).func_177230_c() != GCBlocks.fakeBlock;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        int metadata = state.func_177230_c().func_176201_c(state);
        int angle = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int change = 0;
        switch (angle) {
            case 0: {
                change = 1;
                break;
            }
            case 1: {
                change = 2;
                break;
            }
            case 2: {
                change = 0;
                break;
            }
            case 3: {
                change = 3;
            }
        }
        worldIn.func_180501_a(pos, state.func_177230_c().func_176203_a(change), 3);
        BlockMulti.onPlacement(worldIn, pos, placer, this);
    }

    @Override
    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityDish) {
            ((TileEntityDish)tile).onDestroy(tile);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @Override
    public boolean onUseWrench(World world, BlockPos pos, EntityPlayer entityPlayer, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        return true;
    }

    @Override
    public boolean onSneakMachineActivated(World world, BlockPos pos, EntityPlayer entityPlayer, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState metadata) {
        return new TileEntityDish();
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public String getShiftDescription(int meta) {
        return GCCoreUtil.translate("tile.radio_telescope.description");
    }

    @Override
    public boolean showDescription(int meta) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean isSealed(World world, BlockPos pos, EnumFacing direction) {
        return true;
    }

    @Override
    public EnumSortCategoryBlock getCategory(int meta) {
        return EnumSortCategoryBlock.GENERAL;
    }
}

