/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import java.util.Random;
import micdoodle8.mods.galacticraft.api.block.IDetectableResource;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBasic
extends Block
implements IDetectableResource,
ISortableBlock {
    public static final PropertyEnum BASIC_TYPE = PropertyEnum.func_177709_a((String)"basictype", EnumBlockBasic.class);

    public BlockBasic(String assetName) {
        super(Material.field_151576_e);
        this.func_149711_c(1.0f);
        this.field_149781_w = 15.0f;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BASIC_TYPE, (Comparable)((Object)EnumBlockBasic.ALUMINUM_DECORATION_BLOCK_0)));
        this.func_149663_c(assetName);
    }

    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        switch (this.func_176201_c(state)) {
            case 8: {
                return GCItems.basicItem;
            }
        }
        return Item.func_150898_a((Block)this);
    }

    public int func_180651_a(IBlockState state) {
        switch (this.func_176201_c(state)) {
            case 8: {
                return 2;
            }
        }
        return this.func_176201_c(state);
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        int bonus = 0;
        if (ConfigManagerCore.quickMode && this.func_176201_c(state) == 8) {
            bonus = 1;
        }
        if (fortune > 0 && Item.func_150898_a((Block)this) != this.func_180660_a(state, random, fortune)) {
            int j = random.nextInt(fortune + 2) - 1;
            if (j < 0) {
                j = 0;
            }
            return this.func_149745_a(random) * (j + 1) + bonus;
        }
        return this.func_149745_a(random) + bonus;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        int metadata = this.func_176201_c(world.func_180495_p(pos));
        if (metadata < 5) {
            return 2.0f;
        }
        if (metadata == 12) {
            return 8.0f;
        }
        if (metadata > 8) {
            return 6.0f;
        }
        return super.getExplosionResistance(world, pos, exploder, explosion);
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        int metadata = this.func_176201_c(blockState);
        if (metadata == 5 || metadata == 6) {
            return 5.0f;
        }
        if (metadata == 7) {
            return 6.0f;
        }
        if (metadata == 8) {
            return 3.0f;
        }
        return this.field_149782_v;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int var4 = 3; var4 <= 13; ++var4) {
            list.add((Object)new ItemStack((Block)this, 1, var4));
        }
    }

    @Override
    public boolean isValueable(IBlockState state) {
        switch (this.func_176201_c(state)) {
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        int metadata = this.func_176201_c(world.func_180495_p(pos));
        if (metadata == 8) {
            return new ItemStack(Item.func_150898_a((Block)this), 1, metadata);
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BASIC_TYPE, (Comparable)((Object)EnumBlockBasic.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumBlockBasic)((Object)state.func_177229_b((IProperty)BASIC_TYPE))).getMeta();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BASIC_TYPE});
    }

    @Override
    public EnumSortCategoryBlock getCategory(int meta) {
        switch (meta) {
            case 3: 
            case 4: {
                return EnumSortCategoryBlock.DECORATION;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return EnumSortCategoryBlock.ORE;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return EnumSortCategoryBlock.INGOT_BLOCK;
            }
        }
        return EnumSortCategoryBlock.GENERAL;
    }

    public int getExpDrop(IBlockState state, IBlockAccess world, BlockPos pos, int fortune) {
        if (state.func_177230_c() != this) {
            return 0;
        }
        int meta = this.func_176201_c(state);
        if (meta == 8) {
            Random rand = world instanceof World ? ((World)world).field_73012_v : new Random();
            return MathHelper.func_76136_a((Random)rand, (int)2, (int)5);
        }
        return 0;
    }

    public static enum EnumBlockBasic implements IStringSerializable
    {
        ALUMINUM_DECORATION_BLOCK_0(3, "deco_block_0"),
        ALUMINUM_DECORATION_BLOCK_1(4, "deco_block_1"),
        ORE_COPPER(5, "ore_copper_gc"),
        ORE_TIN(6, "ore_tin_gc"),
        ORE_ALUMINUM(7, "ore_aluminum_gc"),
        ORE_SILICON(8, "ore_silicon"),
        DECO_BLOCK_COPPER(9, "block_copper_gc"),
        DECO_BLOCK_TIN(10, "block_tin_gc"),
        DECO_BLOCK_ALUMINUM(11, "block_aluminum_gc"),
        DECO_BLOCK_METEOR_IRON(12, "block_meteoric_iron_gc"),
        DECO_BLOCK_SILICON(13, "block_silicon_gc");

        private final int meta;
        private final String name;

        private EnumBlockBasic(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        public static EnumBlockBasic byMetadata(int meta) {
            return EnumBlockBasic.values()[meta - 3];
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

