/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api.prefab.world.gen;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeAdaptive;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeProviderSpace;
import micdoodle8.mods.galacticraft.api.world.BiomeGenBaseGC;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.layer.IntCache;

public class BiomeProviderDefault
extends BiomeProviderSpace {
    private static final Biome[] biomeCache = new Biome[256];
    private final List<Biome> biomesToSpawnIn;
    private BiomeGenBaseGC biomeTrue;
    private CelestialBody body;

    public BiomeProviderDefault(CelestialBody theBody) {
        this.body = theBody;
        this.biomeTrue = BiomeAdaptive.getDefaultBiomeFor(this.body);
        this.biomesToSpawnIn = new ArrayList<Biome>();
        this.biomesToSpawnIn.add(this.getBiome());
    }

    @Override
    public Biome getBiome() {
        if (this.body != null) {
            BiomeAdaptive.setBody(this.body);
        }
        return BiomeAdaptive.biomeDefault;
    }

    public Biome getBiomeTrue() {
        return this.biomeTrue;
    }

    @Override
    public List func_76932_a() {
        return this.biomesToSpawnIn;
    }

    @Override
    public Biome func_180300_a(BlockPos pos, Biome defaultBiome) {
        return this.getBiome();
    }

    @Override
    public float func_76939_a(float par1, int par2) {
        return par1;
    }

    @Override
    public Biome[] func_76937_a(Biome[] arrayToReuse, int x, int z, int width, int length) {
        return this.func_76931_a(arrayToReuse, x, z, width, length, true);
    }

    @Override
    public Biome[] func_76933_b(Biome[] par1ArrayOfBiome, int par2, int par3, int par4, int par5) {
        return this.func_76931_a(par1ArrayOfBiome, par2, par3, par4, par5, true);
    }

    @Override
    public Biome[] func_76931_a(Biome[] listToReuse, int x, int z, int width, int length, boolean cacheFlag) {
        BiomeAdaptive.setBody(this.body);
        IntCache.func_76446_a();
        int size = width * length;
        if (listToReuse == null || listToReuse.length < size) {
            listToReuse = new Biome[size];
        }
        if (size <= 256) {
            System.arraycopy(biomeCache, 0, listToReuse, 0, size);
        } else {
            System.arraycopy(biomeCache, 0, listToReuse, 0, 256);
            for (int i = 256; i < size; i += i) {
                System.arraycopy(listToReuse, 0, listToReuse, i, size - i < i ? size - i : i);
            }
        }
        return listToReuse;
    }

    @Override
    public boolean func_76940_a(int par1, int par2, int par3, List par4List) {
        return par4List.contains(this.getBiomeTrue());
    }

    @Override
    public BlockPos func_180630_a(int par1, int par2, int par3, List par4List, Random par5Random) {
        int var6 = par1 - par3 >> 2;
        int var7 = par2 - par3 >> 2;
        int var8 = par1 + par3 >> 2;
        int var10 = var8 - var6 + 1;
        int var16 = var6 + 0 % var10 << 2;
        int var17 = var7 + 0 / var10 << 2;
        return new BlockPos(var16, 0, var17);
    }

    @Override
    public void func_76938_b() {
    }

    static {
        for (int i = 0; i < 16; ++i) {
            BiomeProviderDefault.biomeCache[i] = BiomeAdaptive.biomeDefault;
        }
        System.arraycopy(biomeCache, 0, biomeCache, 16, 16);
        System.arraycopy(biomeCache, 0, biomeCache, 32, 32);
        System.arraycopy(biomeCache, 0, biomeCache, 64, 64);
        System.arraycopy(biomeCache, 0, biomeCache, 128, 128);
    }
}

