/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.venus.tile;

import java.util.EnumSet;
import micdoodle8.mods.galacticraft.api.tile.IDisableableMachine;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConnector;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectricalSource;
import micdoodle8.mods.galacticraft.core.inventory.IInventoryDefaults;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.GalacticraftPlanets;
import micdoodle8.mods.galacticraft.planets.venus.VenusBlocks;
import micdoodle8.mods.galacticraft.planets.venus.VenusModule;
import micdoodle8.mods.galacticraft.planets.venus.blocks.BlockGeothermalGenerator;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntityGeothermalGenerator
extends TileBaseUniversalElectricalSource
implements IInventoryDefaults,
ISidedInventory,
IConnector,
IDisableableMachine {
    public static final int MAX_GENERATE_GJ_PER_TICK = 200;
    public static final int MIN_GENERATE_GJ_PER_TICK = 30;
    private boolean validSpout;
    private NonNullList<ItemStack> stacks = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean disabled = false;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int disableCooldown = 0;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int generateWatts = 0;

    public TileEntityGeothermalGenerator() {
        this.storage.setMaxExtract(200.0f);
        this.storage.setMaxReceive(200.0f);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.receiveEnergyGC(null, this.generateWatts, false);
        }
        super.func_73660_a();
        if (this.ticks % 20 == 0) {
            BlockPos below = this.func_174877_v().func_177977_b();
            IBlockState stateBelow = this.field_145850_b.func_180495_p(below);
            boolean lastValidSpout = this.validSpout;
            this.validSpout = false;
            if (stateBelow.func_177230_c() == VenusBlocks.spout) {
                BlockPos pos1 = below.func_177977_b();
                while (this.func_174877_v().func_177956_o() - pos1.func_177956_o() < 20) {
                    IBlockState state = this.field_145850_b.func_180495_p(pos1);
                    if (state.func_177230_c() == VenusModule.sulphuricAcid.getBlock()) {
                        this.validSpout = true;
                        break;
                    }
                    if (!state.func_177230_c().isAir(this.field_145850_b.func_180495_p(pos1), (IBlockAccess)this.field_145850_b, pos1)) break;
                    pos1 = pos1.func_177977_b();
                }
            }
            if (this.field_145850_b.field_72995_K && this.validSpout != lastValidSpout) {
                IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
                this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            this.recharge((ItemStack)this.stacks.get(0));
            if (this.disableCooldown > 0) {
                --this.disableCooldown;
            }
            this.generateWatts = Math.min(Math.max(this.getGenerate(), 0), 200);
        } else if (this.generateWatts > 0 && this.ticks % ((int)(200.0f / (float)(this.generateWatts + 1)) * 5 + 1) == 0) {
            double posX = (double)this.field_174879_c.func_177958_n() + 0.5;
            double posY = (double)this.field_174879_c.func_177956_o() + 1.0;
            double posZ = (double)this.field_174879_c.func_177952_p() + 0.5;
            GalacticraftPlanets.spawnParticle("acidExhaust", new Vector3(posX - 0.25, posY, posZ - 0.25), new Vector3(0.0, 0.025, 0.0), new Object[0]);
            GalacticraftPlanets.spawnParticle("acidExhaust", new Vector3(posX - 0.25, posY, posZ), new Vector3(0.0, 0.025, 0.0), new Object[0]);
            GalacticraftPlanets.spawnParticle("acidExhaust", new Vector3(posX - 0.25, posY, posZ + 0.25), new Vector3(0.0, 0.025, 0.0), new Object[0]);
            GalacticraftPlanets.spawnParticle("acidExhaust", new Vector3(posX, posY, posZ - 0.25), new Vector3(0.0, 0.025, 0.0), new Object[0]);
            GalacticraftPlanets.spawnParticle("acidExhaust", new Vector3(posX, posY, posZ), new Vector3(0.0, 0.025, 0.0), new Object[0]);
            GalacticraftPlanets.spawnParticle("acidExhaust", new Vector3(posX, posY, posZ + 0.25), new Vector3(0.0, 0.025, 0.0), new Object[0]);
            GalacticraftPlanets.spawnParticle("acidExhaust", new Vector3(posX + 0.25, posY, posZ - 0.25), new Vector3(0.0, 0.025, 0.0), new Object[0]);
            GalacticraftPlanets.spawnParticle("acidExhaust", new Vector3(posX + 0.25, posY, posZ), new Vector3(0.0, 0.025, 0.0), new Object[0]);
            GalacticraftPlanets.spawnParticle("acidExhaust", new Vector3(posX + 0.25, posY, posZ + 0.25), new Vector3(0.0, 0.025, 0.0), new Object[0]);
        }
        this.produce();
    }

    private int getGenerate() {
        if (this.getDisabled(0)) {
            return 0;
        }
        if (!this.validSpout) {
            return 0;
        }
        int diff = 170;
        return (int)Math.floor((Math.sin((float)this.ticks / 50.0f) * 0.5 + 0.5) * (double)diff + 30.0);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.stacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)nbt, this.stacks);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        ItemStackHelper.func_191282_a((NBTTagCompound)nbt, this.stacks);
        return nbt;
    }

    public boolean canConnect(EnumFacing direction, NetworkType type) {
        if (direction == null || type != NetworkType.POWER) {
            return false;
        }
        return direction == this.getElectricOutputDirection();
    }

    public EnumSet<EnumFacing> getElectricalInputDirections() {
        return EnumSet.noneOf(EnumFacing.class);
    }

    public EnumFacing getFront() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockGeothermalGenerator) {
            return (EnumFacing)state.func_177229_b((IProperty)BlockGeothermalGenerator.FACING);
        }
        return EnumFacing.NORTH;
    }

    public EnumSet<EnumFacing> getElectricalOutputDirections() {
        return EnumSet.of(this.getFront().func_176746_e());
    }

    public EnumFacing getElectricOutputDirection() {
        return this.getFront().func_176746_e();
    }

    public boolean func_145818_k_() {
        return true;
    }

    public String func_70005_c_() {
        return GCCoreUtil.translate((String)"container.geothermal_generator.name");
    }

    public void setDisabled(int index, boolean disabled) {
        if (this.disableCooldown == 0) {
            if (this.disabled != disabled && this.field_145850_b.field_72995_K) {
                IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
                this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
            }
            this.disabled = disabled;
            this.disableCooldown = 20;
        }
    }

    public boolean getDisabled(int index) {
        return this.disabled;
    }

    public int getScaledElecticalLevel(int i) {
        return (int)Math.floor(this.getEnergyStoredGC() * (float)i / this.getMaxEnergyStoredGC());
    }

    public int func_70302_i_() {
        return this.stacks.size();
    }

    public ItemStack func_70301_a(int var1) {
        return (ItemStack)this.stacks.get(var1);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.stacks, (int)index, (int)count);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack oldstack = ItemStackHelper.func_188383_a(this.stacks, (int)index);
        if (!oldstack.func_190926_b()) {
            this.func_70296_d();
        }
        return oldstack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.stacks.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.stacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this && player.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0};
    }

    public boolean func_180462_a(int slotID, ItemStack itemstack, EnumFacing side) {
        return this.func_94041_b(slotID, itemstack);
    }

    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        return slotID == 0;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        return slotID == 0 && ItemElectricBase.isElectricItem((Item)itemstack.func_77973_b());
    }

    public boolean hasValidSpout() {
        return this.validSpout;
    }
}

