/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.fluid;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;

public class FluidUtils {
    @CapabilityInject(value=IFluidHandler.class)
    public static final Capability<IFluidHandler> FLUID_HANDLER = null;
    public static int B = 1000;
    public static FluidStack water = new FluidStack(FluidRegistry.WATER, 1000);
    public static FluidStack lava = new FluidStack(FluidRegistry.LAVA, 1000);

    public static FluidStack copy(FluidStack liquid, int quantity) {
        liquid = liquid.copy();
        liquid.amount = quantity;
        return liquid;
    }

    public static FluidStack read(NBTTagCompound tag) {
        FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag);
        return stack != null ? stack : FluidUtils.emptyFluid();
    }

    public static NBTTagCompound write(FluidStack fluid, NBTTagCompound tag) {
        return fluid == null || fluid.getFluid() == null ? tag : fluid.writeToNBT(tag);
    }

    public static int getLuminosity(FluidStack stack, double density) {
        Fluid fluid = stack.getFluid();
        if (fluid == null) {
            return 0;
        }
        int light = fluid.getLuminosity(stack);
        if (fluid.isGaseous()) {
            light = (int)((double)light * density);
        }
        return light;
    }

    public static FluidStack emptyFluid() {
        return new FluidStack(water, 0);
    }

    public static boolean hasFluidHandler(TileEntity tile, EnumFacing face) {
        return tile != null && tile.hasCapability(FLUID_HANDLER, face);
    }

    public static boolean hasFluidHandler(TileEntity tile, int face) {
        return FluidUtils.hasFluidHandler(tile, EnumFacing.field_82609_l[face]);
    }

    public static boolean hasFluidHandler(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return FluidUtils.hasFluidHandler(world.func_175625_s(pos), face);
    }

    public static boolean hasFluidHandler(IBlockAccess world, BlockPos pos, int face) {
        return FluidUtils.hasFluidHandler(world.func_175625_s(pos), face);
    }

    public static IFluidHandler getFluidHandler_Raw(TileEntity tile, EnumFacing face) {
        return (IFluidHandler)tile.getCapability(FLUID_HANDLER, face);
    }

    public static IFluidHandler getFluidHandler_Raw(TileEntity tile, int face) {
        return FluidUtils.getFluidHandler_Raw(tile, EnumFacing.field_82609_l[face]);
    }

    public static IFluidHandler getFluidHandler_Raw(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return FluidUtils.getFluidHandler_Raw(world.func_175625_s(pos), face);
    }

    public static IFluidHandler getFluidHandler_Raw(IBlockAccess world, BlockPos pos, int face) {
        return FluidUtils.getFluidHandler_Raw(world.func_175625_s(pos), face);
    }

    public static IFluidHandler getFluidHandlerOr(TileEntity tile, EnumFacing face, IFluidHandler _default) {
        return FluidUtils.hasFluidHandler(tile, face) ? FluidUtils.getFluidHandler_Raw(tile, face) : _default;
    }

    public static IFluidHandler getFluidHandlerOr(TileEntity tile, int face, IFluidHandler _default) {
        return FluidUtils.hasFluidHandler(tile, face) ? FluidUtils.getFluidHandler_Raw(tile, face) : _default;
    }

    public static IFluidHandler getFluidHandlerOr(IBlockAccess world, BlockPos pos, EnumFacing face, IFluidHandler _default) {
        return FluidUtils.getFluidHandlerOr(world.func_175625_s(pos), face, _default);
    }

    public static IFluidHandler getFluidHandlerOr(IBlockAccess world, BlockPos pos, int face, IFluidHandler _default) {
        return FluidUtils.getFluidHandlerOr(world.func_175625_s(pos), face, _default);
    }

    public static IFluidHandler getFluidHandler(TileEntity tile, EnumFacing face) {
        return FluidUtils.getFluidHandlerOr(tile, face, null);
    }

    public static IFluidHandler getFluidHandler(TileEntity tile, int face) {
        return FluidUtils.getFluidHandlerOr(tile, face, null);
    }

    public static IFluidHandler getFluidHandler(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return FluidUtils.getFluidHandlerOr(world, pos, face, null);
    }

    public static IFluidHandler getFluidHandler(IBlockAccess world, BlockPos pos, int face) {
        return FluidUtils.getFluidHandlerOr(world, pos, face, null);
    }

    public static IFluidHandler getFluidHandlerOrEmpty(TileEntity tile, EnumFacing face) {
        return FluidUtils.getFluidHandlerOr(tile, face, (IFluidHandler)EmptyFluidHandler.INSTANCE);
    }

    public static IFluidHandler getFluidHandlerOrEmpty(TileEntity tile, int face) {
        return FluidUtils.getFluidHandlerOr(tile, face, (IFluidHandler)EmptyFluidHandler.INSTANCE);
    }

    public static IFluidHandler getFluidHandlerOrEmpty(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return FluidUtils.getFluidHandlerOr(world.func_175625_s(pos), face, (IFluidHandler)EmptyFluidHandler.INSTANCE);
    }

    public static IFluidHandler getFluidHandlerOrEmpty(IBlockAccess world, BlockPos pos, int face) {
        return FluidUtils.getFluidHandlerOr(world.func_175625_s(pos), face, (IFluidHandler)EmptyFluidHandler.INSTANCE);
    }
}

