/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.util.math;

public class MathX {
    public static final double PI_D = Math.PI;
    public static final float PI_F = (float)Math.PI;

    private MathX() {
    }

    public static float sin(float a) {
        return (float)Math.sin(a);
    }

    public static float cos(float a) {
        return (float)Math.cos(a);
    }

    public static float tan(float a) {
        return (float)Math.tan(a);
    }

    public static float atan2(float y, float x) {
        return (float)Math.atan2(y, x);
    }

    public static float toRadians(float angdeg) {
        return (float)Math.toRadians(angdeg);
    }

    public static float toDegrees(float angrad) {
        return (float)Math.toDegrees(angrad);
    }

    public static float normDeg(float a) {
        if ((a %= 360.0f) >= 180.0f) {
            a -= 360.0f;
        }
        if (a < -180.0f) {
            a += 360.0f;
        }
        return a;
    }

    public static double normDeg(double a) {
        if ((a %= 360.0) >= 180.0) {
            a -= 360.0;
        }
        if (a < -180.0) {
            a += 360.0;
        }
        return a;
    }

    public static float normRad(float a) {
        if ((a %= (float)Math.PI * 2) >= (float)Math.PI) {
            a -= (float)Math.PI * 2;
        }
        if (a < (float)(-Math.PI)) {
            a += (float)Math.PI * 2;
        }
        return a;
    }

    public static double normRad(double a) {
        if ((a %= Math.PI * 2) >= Math.PI) {
            a -= Math.PI * 2;
        }
        if (a < -Math.PI) {
            a += Math.PI * 2;
        }
        return a;
    }

    public static float sqrtf(float f) {
        return (float)Math.sqrt(f);
    }

    public static float clamp(float value, float min, float max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static double clamp(double value, double min, double max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static int clamp(int value, int min, int max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static float updateRotation(float r1, float r2, float step) {
        return r1 + MathX.clamp(MathX.normDeg(r2 - r1), -step, step);
    }
}

