/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.client.render.breeds;

import info.ata4.minecraft.dragon.DragonMounts;
import info.ata4.minecraft.dragon.client.model.DragonModel;
import info.ata4.minecraft.dragon.client.render.DragonRenderer;
import info.ata4.minecraft.dragon.client.render.LayerRendererDragonGlow;
import info.ata4.minecraft.dragon.client.render.LayerRendererDragonSaddle;
import info.ata4.minecraft.dragon.client.render.breeds.DragonBreedRenderer;
import info.ata4.minecraft.dragon.server.entity.EntityTameableDragon;
import info.ata4.minecraft.dragon.server.entity.breeds.EnumDragonBreed;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.util.ResourceLocation;

public class DefaultDragonBreedRenderer
implements DragonBreedRenderer {
    protected final List<LayerRenderer<EntityTameableDragon>> layers = new ArrayList<LayerRenderer<EntityTameableDragon>>();
    private final DragonRenderer renderer;
    private final DragonModel model;
    private final ResourceLocation bodyTexture;
    private final ResourceLocation glowTexture;
    private final ResourceLocation glowAnimTexture;
    private final ResourceLocation saddleTexture;
    private final ResourceLocation eggTexture;
    private final ResourceLocation dissolveTexture;

    public DefaultDragonBreedRenderer(DragonRenderer parent, EnumDragonBreed breed) {
        this.renderer = parent;
        this.model = new DragonModel(breed);
        this.layers.add(new LayerRendererDragonGlow(parent, this, this.model));
        this.layers.add(new LayerRendererDragonSaddle(parent, this, this.model));
        String skin = breed.getBreed().getSkin();
        this.bodyTexture = new ResourceLocation(DragonMounts.AID, "textures/entities/dragon/" + skin + "/body.png");
        this.glowTexture = new ResourceLocation(DragonMounts.AID, "textures/entities/dragon/" + skin + "/glow.png");
        this.glowAnimTexture = new ResourceLocation(DragonMounts.AID, "textures/entities/dragon/" + skin + "/glow_anim.png");
        this.saddleTexture = new ResourceLocation(DragonMounts.AID, "textures/entities/dragon/" + skin + "/saddle.png");
        this.eggTexture = new ResourceLocation(DragonMounts.AID, "textures/entities/dragon/" + skin + "/egg.png");
        this.dissolveTexture = new ResourceLocation(DragonMounts.AID, "textures/entities/dragon/dissolve.png");
    }

    @Override
    public List<LayerRenderer<EntityTameableDragon>> getLayers() {
        return Collections.unmodifiableList(this.layers);
    }

    @Override
    public DragonRenderer getRenderer() {
        return this.renderer;
    }

    @Override
    public DragonModel getModel() {
        return this.model;
    }

    @Override
    public ResourceLocation getBodyTexture() {
        return this.bodyTexture;
    }

    @Override
    public ResourceLocation getGlowTexture() {
        return this.glowTexture;
    }

    @Override
    public ResourceLocation getGlowAnimTexture() {
        return this.glowAnimTexture;
    }

    @Override
    public ResourceLocation getSaddleTexture() {
        return this.saddleTexture;
    }

    @Override
    public ResourceLocation getEggTexture() {
        return this.eggTexture;
    }

    @Override
    public ResourceLocation getDissolveTexture() {
        return this.dissolveTexture;
    }
}

