/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.factorization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Random;
import javax.vecmath.Vector3d;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.chunk.Chunk;
import pl.asie.charset.lib.factorization.Orientation;
import pl.asie.charset.lib.factorization.Quaternion;

public final class SpaceUtil {
    public static final byte GET_POINT_MIN = 0;
    public static final byte GET_POINT_MAX = 7;
    private static final int[][] ROTATION_MATRIX = new int[][]{{0, 1, 4, 5, 3, 2}, {0, 1, 5, 4, 2, 3}, {5, 4, 2, 3, 0, 1}, {4, 5, 2, 3, 1, 0}, {2, 3, 1, 0, 4, 5}, {3, 2, 0, 1, 4, 5}, {0, 1, 2, 3, 4, 5}};

    public static EnumFacing determineOrientation(EntityLivingBase player) {
        if (player.field_70125_A > 75.0f) {
            return EnumFacing.DOWN;
        }
        if (player.field_70125_A <= -75.0f) {
            return EnumFacing.UP;
        }
        return SpaceUtil.determineFlatOrientation(player);
    }

    public static EnumFacing determineFlatOrientation(EntityLivingBase player) {
        int var7 = MathHelper.func_76128_c((double)((double)((180.0f + player.field_70177_z) * 4.0f / 360.0f) + 0.5)) & 3;
        int r = var7 == 0 ? 2 : (var7 == 1 ? 5 : (var7 == 2 ? 3 : (var7 == 3 ? 4 : 0)));
        return EnumFacing.field_82609_l[r];
    }

    @Deprecated
    public static Vec3d newvec() {
        return new Vec3d(0.0, 0.0, 0.0);
    }

    public static Vec3d copy(Vec3d a) {
        return new Vec3d(a.field_72450_a, a.field_72448_b, a.field_72449_c);
    }

    public static AxisAlignedBB copy(AxisAlignedBB box) {
        return new AxisAlignedBB(box.field_72340_a, box.field_72338_b, box.field_72339_c, box.field_72336_d, box.field_72337_e, box.field_72334_f);
    }

    public static Vec3d fromEntPos(Entity ent) {
        return new Vec3d(ent.field_70165_t, ent.field_70163_u, ent.field_70161_v);
    }

    public static Vec3d fromEntVel(Entity ent) {
        return new Vec3d(ent.field_70159_w, ent.field_70181_x, ent.field_70179_y);
    }

    public static void toEntVel(Entity ent, Vec3d vec) {
        ent.field_70159_w = vec.field_72450_a;
        ent.field_70181_x = vec.field_72448_b;
        ent.field_70179_y = vec.field_72449_c;
    }

    public static Vec3d fromPlayerEyePos(EntityPlayer ent) {
        if (ent.field_70170_p.field_72995_K) {
            return new Vec3d(ent.field_70165_t, ent.field_70163_u + (double)(ent.func_70047_e() - ent.getDefaultEyeHeight()), ent.field_70161_v);
        }
        return new Vec3d(ent.field_70165_t, ent.field_70163_u + (double)ent.func_70047_e(), ent.field_70161_v);
    }

    public static void toEntPos(Entity ent, Vec3d pos) {
        ent.field_70165_t = pos.field_72450_a;
        ent.field_70163_u = pos.field_72448_b;
        ent.field_70161_v = pos.field_72449_c;
    }

    public static void setEntPos(Entity ent, Vec3d pos) {
        ent.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
    }

    public static AxisAlignedBB setMin(AxisAlignedBB aabb, Vec3d v) {
        return new AxisAlignedBB(v.field_72450_a, v.field_72448_b, v.field_72449_c, aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
    }

    public static Vec3d getMax(AxisAlignedBB aabb) {
        return new Vec3d(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
    }

    public static Vec3d getMin(AxisAlignedBB aabb) {
        return new Vec3d(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c);
    }

    public static AxisAlignedBB setMax(AxisAlignedBB aabb, Vec3d v) {
        return new AxisAlignedBB(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c, v.field_72450_a, v.field_72448_b, v.field_72449_c);
    }

    public static Vec3d getMiddle(AxisAlignedBB ab) {
        return new Vec3d((ab.field_72340_a + ab.field_72336_d) / 2.0, (ab.field_72338_b + ab.field_72337_e) / 2.0, (ab.field_72339_c + ab.field_72334_f) / 2.0);
    }

    public static AxisAlignedBB incrContract(AxisAlignedBB box, double dx, double dy, double dz) {
        return box.func_72314_b(-dx, -dy, -dz);
    }

    public static Vec3d fromDirection(EnumFacing dir) {
        return new Vec3d(dir.func_176730_m());
    }

    public static Vec3d getVertex(AxisAlignedBB box, byte pointFlags) {
        boolean xSide = (pointFlags & 1) == 1;
        boolean ySide = (pointFlags & 2) == 2;
        boolean zSide = (pointFlags & 4) == 4;
        return new Vec3d(xSide ? box.field_72340_a : box.field_72336_d, ySide ? box.field_72338_b : box.field_72337_e, zSide ? box.field_72339_c : box.field_72334_f);
    }

    public static AxisAlignedBB flatten(AxisAlignedBB box, EnumFacing face) {
        byte[] lows = new byte[]{2, 0, 4, 0, 1, 0};
        byte[] hghs = new byte[]{7, 5, 7, 3, 7, 6};
        byte low = lows[face.ordinal()];
        byte high = hghs[face.ordinal()];
        assert (low != high);
        assert ((~low & 7) != high);
        return SpaceUtil.newBox(SpaceUtil.getVertex(box, low), SpaceUtil.getVertex(box, high));
    }

    public static double getDiagonalLength(AxisAlignedBB ab) {
        double x = ab.field_72336_d - ab.field_72340_a;
        double y = ab.field_72337_e - ab.field_72338_b;
        double z = ab.field_72334_f - ab.field_72339_c;
        return Math.sqrt(x * x + y * y + z * z);
    }

    public static Vec3d averageVec(Vec3d a, Vec3d b) {
        return new Vec3d((a.field_72450_a + b.field_72450_a) / 2.0, (a.field_72448_b + b.field_72448_b) / 2.0, (a.field_72449_c + b.field_72449_c) / 2.0);
    }

    public static double getAngle(Vec3d a, Vec3d b) {
        double mags;
        double dot = a.func_72430_b(b);
        double div = dot / (mags = a.func_72433_c() * b.func_72433_c());
        if (div > 1.0) {
            div = 1.0;
        }
        if (div < -1.0) {
            div = -1.0;
        }
        return Math.acos(div);
    }

    public static AxisAlignedBB newBox(Vec3d min, Vec3d max) {
        return new AxisAlignedBB(min.field_72450_a, min.field_72448_b, min.field_72449_c, max.field_72450_a, max.field_72448_b, max.field_72449_c);
    }

    public static AxisAlignedBB newBox(Vec3d[] parts) {
        return SpaceUtil.newBox(SpaceUtil.getLowest(parts), SpaceUtil.getHighest(parts));
    }

    public static Vec3d scale(Vec3d base, double s) {
        return new Vec3d(base.field_72450_a * s, base.field_72448_b * s, base.field_72449_c * s);
    }

    public static Vec3d componentMultiply(Vec3d a, Vec3d b) {
        return new Vec3d(a.field_72450_a + b.field_72448_b, a.field_72448_b + b.field_72448_b, a.field_72449_c + b.field_72448_b);
    }

    public static Vec3d componentMultiply(Vec3d a, double x, double y, double z) {
        return new Vec3d(a.field_72450_a + x, a.field_72448_b + y, a.field_72449_c + z);
    }

    public static AxisAlignedBB newBoxSort(Vec3d min, Vec3d max) {
        double minX = Math.min(min.field_72450_a, max.field_72450_a);
        double minY = Math.min(min.field_72448_b, max.field_72448_b);
        double minZ = Math.min(min.field_72449_c, max.field_72449_c);
        double maxX = Math.max(min.field_72450_a, max.field_72450_a);
        double maxY = Math.max(min.field_72448_b, max.field_72448_b);
        double maxZ = Math.max(min.field_72449_c, max.field_72449_c);
        return new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public static AxisAlignedBB newBoxUnsort(Vec3d min, Vec3d max) {
        return new AxisAlignedBB(min.field_72450_a, min.field_72448_b, min.field_72449_c, max.field_72450_a, max.field_72448_b, max.field_72449_c);
    }

    public static AxisAlignedBB addCoord(AxisAlignedBB box, Vec3d vec) {
        return box.func_72321_a(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public static Vec3d[] getCorners(AxisAlignedBB box) {
        return new Vec3d[]{new Vec3d(box.field_72340_a, box.field_72338_b, box.field_72339_c), new Vec3d(box.field_72340_a, box.field_72337_e, box.field_72339_c), new Vec3d(box.field_72336_d, box.field_72337_e, box.field_72339_c), new Vec3d(box.field_72336_d, box.field_72338_b, box.field_72339_c), new Vec3d(box.field_72340_a, box.field_72338_b, box.field_72334_f), new Vec3d(box.field_72340_a, box.field_72337_e, box.field_72334_f), new Vec3d(box.field_72336_d, box.field_72337_e, box.field_72334_f), new Vec3d(box.field_72336_d, box.field_72338_b, box.field_72334_f)};
    }

    public static Vec3d getLowest(Vec3d[] vs) {
        double z = 0.0;
        double y = 0.0;
        double x = 0.0;
        boolean first = true;
        for (int i = 0; i < vs.length; ++i) {
            Vec3d v = vs[i];
            if (v == null) continue;
            if (first) {
                first = false;
                x = v.field_72450_a;
                y = v.field_72448_b;
                z = v.field_72449_c;
                continue;
            }
            if (v.field_72450_a < x) {
                x = v.field_72450_a;
            }
            if (v.field_72448_b < y) {
                y = v.field_72448_b;
            }
            if (!(v.field_72449_c < z)) continue;
            z = v.field_72449_c;
        }
        return new Vec3d(x, y, z);
    }

    public static Vec3d getHighest(Vec3d[] vs) {
        double z = 0.0;
        double y = 0.0;
        double x = 0.0;
        boolean first = true;
        for (int i = 0; i < vs.length; ++i) {
            Vec3d v = vs[i];
            if (v == null) continue;
            if (first) {
                first = false;
                x = v.field_72450_a;
                y = v.field_72448_b;
                z = v.field_72449_c;
                continue;
            }
            if (v.field_72450_a > x) {
                x = v.field_72450_a;
            }
            if (v.field_72448_b > y) {
                y = v.field_72448_b;
            }
            if (!(v.field_72449_c > z)) continue;
            z = v.field_72449_c;
        }
        return new Vec3d(x, y, z);
    }

    public static ArrayList<EnumFacing> getRandomDirections(Random rand) {
        ArrayList<EnumFacing> ret = new ArrayList<EnumFacing>(6);
        for (int i = 0; i < 6; ++i) {
            ret.add(SpaceUtil.getOrientation(i));
        }
        Collections.shuffle(ret, rand);
        return ret;
    }

    public static int getAxis(EnumFacing fd) {
        if (fd.func_176730_m().func_177958_n() != 0) {
            return 1;
        }
        if (fd.func_176730_m().func_177956_o() != 0) {
            return 2;
        }
        if (fd.func_176730_m().func_177952_p() != 0) {
            return 3;
        }
        return 0;
    }

    public static boolean isZero(Vec3d vec) {
        return vec.field_72450_a == 0.0 && vec.field_72448_b == 0.0 && vec.field_72449_c == 0.0;
    }

    public static double lineDistance(Vec3d lineVec, Vec3d point) {
        double mag = lineVec.func_72433_c();
        Vec3d nPoint = SpaceUtil.scale(point, -1.0);
        return lineVec.func_72431_c(nPoint).func_72433_c() / mag;
    }

    public static EnumFacing getOrientation(int ordinal) {
        if (ordinal < 0) {
            return null;
        }
        if (ordinal >= 6) {
            return null;
        }
        return EnumFacing.field_82609_l[ordinal];
    }

    public static Orientation getOrientation(EntityLivingBase player, EnumFacing facing, Vec3d hit) {
        Orientation perfect;
        double dist;
        double v;
        double u;
        if (facing == null) {
            facing = EnumFacing.DOWN;
        }
        assert (facing != null);
        switch (facing) {
            default: {
                u = 1.0 - hit.field_72450_a;
                v = hit.field_72449_c;
                break;
            }
            case UP: {
                u = hit.field_72450_a;
                v = hit.field_72449_c;
                break;
            }
            case NORTH: {
                u = hit.field_72450_a;
                v = hit.field_72448_b;
                break;
            }
            case SOUTH: {
                u = 1.0 - hit.field_72450_a;
                v = hit.field_72448_b;
                break;
            }
            case WEST: {
                u = 1.0 - hit.field_72449_c;
                v = hit.field_72448_b;
                break;
            }
            case EAST: {
                u = hit.field_72449_c;
                v = hit.field_72448_b;
            }
        }
        double angle = Math.toDegrees(Math.atan2(v -= 0.5, u -= 0.5)) + 180.0;
        angle = (angle + 45.0) % 360.0;
        int pointy = (int)(angle / 90.0);
        pointy = (pointy + 1) % 4;
        Orientation fo = Orientation.fromDirection(facing);
        for (int X = 0; X < pointy; ++X) {
            fo = fo.getNextRotationOnFace();
        }
        EnumFacing orient = SpaceUtil.determineOrientation(player);
        if (orient.func_176740_k() != EnumFacing.Axis.Y && facing.func_176740_k() == EnumFacing.Axis.Y) {
            Orientation perfect2;
            facing = orient;
            Orientation orientation = fo = orient == null ? null : Orientation.fromDirection(orient.func_176734_d());
            if (fo != null && (perfect2 = fo.pointTopTo(EnumFacing.UP)) != null) {
                fo = perfect2;
            }
        }
        if ((dist = Math.max(Math.abs(u), Math.abs(v))) < 0.33 && (perfect = fo.pointTopTo(EnumFacing.UP)) != null) {
            fo = perfect;
        }
        return fo;
    }

    public static int sign(EnumFacing dir) {
        if (dir == null) {
            return 0;
        }
        return dir.func_176743_c().func_179524_a();
    }

    public static double sum(Vec3d vec) {
        return vec.field_72450_a + vec.field_72448_b + vec.field_72449_c;
    }

    public static EnumFacing round(Vec3d vec, EnumFacing not) {
        if (SpaceUtil.isZero(vec)) {
            return null;
        }
        Vec3i work = null;
        double bestAngle = Double.POSITIVE_INFINITY;
        EnumFacing closest = null;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            double dot;
            if (dir == not || !((dot = SpaceUtil.getAngle(vec, new Vec3d(work = dir.func_176730_m()))) < bestAngle)) continue;
            bestAngle = dot;
            closest = dir;
        }
        return closest;
    }

    public static Vec3d floor(Vec3d vec) {
        return new Vec3d(Math.floor(vec.field_72450_a), Math.floor(vec.field_72448_b), Math.floor(vec.field_72449_c));
    }

    public static Vec3d normalize(Vec3d v) {
        double length = v.func_72433_c();
        if (length == 0.0) {
            return SpaceUtil.newvec();
        }
        double inv = 1.0 / length;
        if (Double.isNaN(inv) || Double.isInfinite(inv)) {
            return SpaceUtil.newvec();
        }
        return SpaceUtil.scale(v, inv);
    }

    public static AxisAlignedBB include(AxisAlignedBB box, BlockPos at) {
        double minX = box.field_72340_a;
        double maxX = box.field_72336_d;
        double minY = box.field_72338_b;
        double maxY = box.field_72337_e;
        double minZ = box.field_72339_c;
        double maxZ = box.field_72334_f;
        if ((double)at.func_177958_n() < minX) {
            minX = at.func_177958_n();
        }
        if ((double)(at.func_177958_n() + 1) > maxX) {
            maxX = at.func_177958_n() + 1;
        }
        if ((double)at.func_177956_o() < minY) {
            minY = at.func_177956_o();
        }
        if ((double)(at.func_177956_o() + 1) > maxY) {
            maxY = at.func_177956_o() + 1;
        }
        if ((double)at.func_177952_p() < minZ) {
            minZ = at.func_177952_p();
        }
        if ((double)(at.func_177952_p() + 1) > maxZ) {
            maxZ = at.func_177952_p() + 1;
        }
        return new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public static AxisAlignedBB include(AxisAlignedBB box, Vec3d at) {
        double minX = box.field_72340_a;
        double maxX = box.field_72336_d;
        double minY = box.field_72338_b;
        double maxY = box.field_72337_e;
        double minZ = box.field_72339_c;
        double maxZ = box.field_72334_f;
        if (at.field_72450_a < minX) {
            minX = at.field_72450_a;
        }
        if (at.field_72450_a > maxX) {
            maxX = at.field_72450_a;
        }
        if (at.field_72448_b < minY) {
            minY = at.field_72448_b;
        }
        if (at.field_72448_b > maxY) {
            maxY = at.field_72448_b;
        }
        if (at.field_72449_c < minZ) {
            minZ = at.field_72449_c;
        }
        if (at.field_72449_c > maxZ) {
            maxZ = at.field_72449_c;
        }
        return new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public static double getVolume(AxisAlignedBB box) {
        if (box == null) {
            return 0.0;
        }
        double x = box.field_72336_d - box.field_72340_a;
        double y = box.field_72337_e - box.field_72338_b;
        double z = box.field_72334_f - box.field_72339_c;
        double volume = x * y * z;
        if (volume < 0.0) {
            return 0.0;
        }
        return volume;
    }

    public static AxisAlignedBB getBox(BlockPos at, int R) {
        return new AxisAlignedBB(at.func_177982_a(-R, -R, -R), at.func_177982_a(R, R, R));
    }

    public static Vec3d dup(double d) {
        return new Vec3d(d, d, d);
    }

    public static EnumFacing rotateDirection(EnumFacing dir, Quaternion rot, Iterable<EnumFacing> allow) {
        Vec3d v = SpaceUtil.fromDirection(dir);
        rot.applyRotation(v);
        EnumFacing best = null;
        double bestDot = Double.POSITIVE_INFINITY;
        for (EnumFacing fd : allow) {
            Vec3d f = SpaceUtil.fromDirection(fd);
            rot.applyRotation(f);
            double dot = v.func_72430_b(f);
            if (!(dot < bestDot)) continue;
            bestDot = dot;
            best = fd;
        }
        return best;
    }

    public static EnumFacing rotateDirectionAndExclude(EnumFacing dir, Quaternion rot, Collection<EnumFacing> allow) {
        EnumFacing ret = SpaceUtil.rotateDirection(dir, rot, allow);
        allow.remove(ret);
        allow.remove(ret.func_176734_d());
        return ret;
    }

    public static Vec3d subtract(Vec3d you, Vec3d me) {
        return you.func_178788_d(me);
    }

    public static Vec3d setX(Vec3d v, double x) {
        return new Vec3d(x, v.field_72448_b, v.field_72449_c);
    }

    public static Vec3d setY(Vec3d v, double y) {
        return new Vec3d(v.field_72450_a, y, v.field_72449_c);
    }

    public static Vec3d setZ(Vec3d v, double z) {
        return new Vec3d(v.field_72450_a, v.field_72448_b, z);
    }

    public static EnumFacing fromAxis(EnumFacing.Axis a) {
        if (a == EnumFacing.Axis.Y) {
            return EnumFacing.DOWN;
        }
        if (a == EnumFacing.Axis.X) {
            return EnumFacing.WEST;
        }
        if (a == EnumFacing.Axis.Z) {
            return EnumFacing.NORTH;
        }
        return null;
    }

    public static AxisAlignedBB newBox() {
        return new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public static Vec3d newVec() {
        return new Vec3d(0.0, 0.0, 0.0);
    }

    public static AxisAlignedBB newBoxAround(BlockPos pos) {
        return new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1));
    }

    public static EnumFacing rotate(EnumFacing dir, EnumFacing axis) {
        return EnumFacing.field_82609_l[ROTATION_MATRIX[axis.ordinal()][dir.ordinal()]];
    }

    public static EnumFacing rotateBack(EnumFacing dir, EnumFacing axis) {
        return SpaceUtil.rotate(SpaceUtil.rotate(SpaceUtil.rotate(dir, axis), axis), axis);
    }

    public static Iterable<BlockPos.MutableBlockPos> iteratePos(BlockPos src, int r) {
        return BlockPos.func_177975_b((BlockPos)src.func_177982_a(-r, -r, -r), (BlockPos)src.func_177982_a(r, r, r));
    }

    public static Vector3d toJavax(Vec3d val) {
        return new Vector3d(val.field_72450_a, val.field_72448_b, val.field_72449_c);
    }

    public static AxisAlignedBB getBox(Chunk chunk) {
        int minX = chunk.field_76635_g << 4;
        int minZ = chunk.field_76647_h << 4;
        return new AxisAlignedBB((double)minX, 0.0, (double)minZ, (double)(minX + 16), 255.0, (double)(minZ + 16));
    }

    public static boolean equals(AxisAlignedBB a, AxisAlignedBB b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.field_72340_a == b.field_72340_a && a.field_72338_b == b.field_72338_b && a.field_72339_c == b.field_72339_c && a.field_72336_d == b.field_72336_d && a.field_72337_e == b.field_72337_e && a.field_72334_f == b.field_72334_f;
    }

    public static boolean equals(Vec3d a, Vec3d b) {
        return a.field_72450_a == b.field_72450_a && a.field_72448_b == b.field_72448_b && a.field_72449_c == b.field_72449_c;
    }

    public static double lengthSquare(Vec3d vec) {
        return vec.field_72450_a * vec.field_72450_a + vec.field_72448_b * vec.field_72448_b + vec.field_72449_c * vec.field_72449_c;
    }
}

