/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.io.File;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.RecipeSorter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pl.asie.charset.api.audio.AudioAPI;
import pl.asie.charset.lib.Capabilities;
import pl.asie.charset.lib.PlayerDeathHandler;
import pl.asie.charset.lib.ProxyCommon;
import pl.asie.charset.lib.audio.AudioDataDFPWM;
import pl.asie.charset.lib.audio.AudioDataSound;
import pl.asie.charset.lib.audio.AudioSinkBlock;
import pl.asie.charset.lib.audio.PacketAudioData;
import pl.asie.charset.lib.audio.PacketAudioStop;
import pl.asie.charset.lib.misc.IconCharset;
import pl.asie.charset.lib.network.PacketRegistry;
import pl.asie.charset.lib.notify.NotifyImplementation;
import pl.asie.charset.lib.recipe.RecipeCharset;
import pl.asie.charset.lib.recipe.RecipeDyeableItem;
import pl.asie.charset.lib.utils.ColorUtils;
import pl.asie.charset.lib.utils.DataSerializersCharset;
import pl.asie.charset.lib.wires.ItemWire;
import pl.asie.charset.lib.wires.RecipeObjectWire;
import pl.asie.charset.lib.wires.RecipeResultWire;
import pl.asie.charset.lib.wires.WireFactory;
import pl.asie.charset.lib.wires.WireManager;

@Mod(modid="CharsetLib", name="\u203d", version="0.3.5", updateJSON="http://charset.asie.pl/update.json", dependencies="after:mcmultipart;after:JEI@[3.13.3.373,)", acceptableRemoteVersions="0.3.5", acceptedMinecraftVersions="[1.10.2]")
public class ModCharsetLib {
    public static final boolean INDEV = false;
    public static final String UPDATE_URL = "http://charset.asie.pl/update.json";
    public static final String MODID = "CharsetLib";
    public static final String NAME = "\u203d";
    public static final String VERSION = "0.3.5";
    public static final String DEP_MCMP = "required-after:Forge@[11.15.0.1715,);required-after:CharsetLib@0.3.5;required-after:mcmultipart@[1.3.0,)";
    public static final String DEP_NO_MCMP = "required-after:Forge@[11.15.0.1715,);required-after:CharsetLib@0.3.5;after:mcmultipart";
    public static final String ACCEPTABLE_REMOTE_VERSIONS = "0.3.5";
    public static Supplier<Calendar> calendar = Suppliers.memoizeWithExpiration((Supplier)new Supplier<Calendar>(){

        public Calendar get() {
            return Calendar.getInstance();
        }
    }, (long)1L, (TimeUnit)TimeUnit.MINUTES);
    @Mod.Instance(value="CharsetLib")
    public static ModCharsetLib instance;
    public static PacketRegistry packet;
    @SidedProxy(clientSide="pl.asie.charset.lib.ProxyClient", serverSide="pl.asie.charset.lib.ProxyCommon")
    public static ProxyCommon proxy;
    public static PlayerDeathHandler deathHandler;
    public static IconCharset charsetIconItem;
    public static final CreativeTabs CREATIVE_TAB;
    public static Logger logger;
    private File configurationDirectory;

    public File getConfigFile(String filename) {
        return new File(this.configurationDirectory, filename);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = LogManager.getLogger((String)MODID);
        this.configurationDirectory = new File(event.getModConfigurationDirectory(), "charset");
        if (!this.configurationDirectory.exists()) {
            this.configurationDirectory.mkdir();
        }
        charsetIconItem = new IconCharset();
        GameRegistry.register((IForgeRegistryEntry)charsetIconItem.setRegistryName("icon"));
        WireManager.ITEM = new ItemWire();
        GameRegistry.register((IForgeRegistryEntry)WireManager.ITEM.setRegistryName("wire"));
        for (int i = 0; i < 512; ++i) {
            proxy.registerItemModel((Item)WireManager.ITEM, i, "charsetlib:wire");
        }
        proxy.registerItemModel(charsetIconItem, 0, "charsetlib:icon");
        Capabilities.init();
        NotifyImplementation.init();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init();
        packet = new PacketRegistry(MODID);
        packet.registerPacket(1, PacketAudioData.class);
        packet.registerPacket(2, PacketAudioStop.class);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        ColorUtils.init();
        DataSerializersCharset.init();
        GameRegistry.addRecipe((IRecipe)new RecipeDyeableItem());
        RecipeSorter.register((String)"charsetDyeable", RecipeDyeableItem.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        RecipeSorter.register((String)"charset", RecipeCharset.class, (RecipeSorter.Category)RecipeSorter.Category.UNKNOWN, (String)"before:minecraft:shaped");
        for (WireFactory factory : WireManager.REGISTRY.getValues()) {
            GameRegistry.addRecipe((IRecipe)RecipeCharset.Builder.create(new RecipeResultWire(factory, false, 1)).shapeless(new RecipeObjectWire(factory, true)).build());
            GameRegistry.addRecipe((IRecipe)RecipeCharset.Builder.create(new RecipeResultWire(factory, true, 1)).shapeless(new RecipeObjectWire(factory, false)).build());
        }
        AudioAPI.DATA_REGISTRY.register(AudioDataDFPWM.class);
        AudioAPI.DATA_REGISTRY.register(AudioDataSound.class);
        AudioAPI.SINK_REGISTRY.register(AudioSinkBlock.class);
    }

    @Mod.EventHandler
    public void postInit(FMLInitializationEvent event) {
        if (deathHandler.hasPredicate()) {
            MinecraftForge.EVENT_BUS.register((Object)deathHandler);
        }
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        NotifyImplementation.instance.registerServerCommands(event);
    }

    @Mod.EventHandler
    public void serverStop(FMLServerStoppedEvent event) {
        proxy.onServerStop();
    }

    static {
        deathHandler = new PlayerDeathHandler();
        CREATIVE_TAB = new CreativeTabs("charset"){

            public Item func_78016_d() {
                return charsetIconItem;
            }
        };
    }
}

